/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.signature;

import com.google.crypto.tink.KeyManager;
import com.google.crypto.tink.PublicKeyVerify;
import com.google.crypto.tink.proto.Ed25519PublicKey;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.subtle.Ed25519Verify;
import com.google.crypto.tink.subtle.Validators;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import java.security.GeneralSecurityException;

class Ed25519PublicKeyManager
implements KeyManager<PublicKeyVerify> {
    public static final String TYPE_URL = "type.googleapis.com/google.crypto.tink.Ed25519PublicKey";
    private static final int VERSION = 0;

    Ed25519PublicKeyManager() {
    }

    @Override
    public PublicKeyVerify getPrimitive(ByteString serialized) throws GeneralSecurityException {
        try {
            Ed25519PublicKey keyProto = Ed25519PublicKey.parseFrom(serialized);
            return this.getPrimitive((MessageLite)keyProto);
        }
        catch (InvalidProtocolBufferException e) {
            throw new GeneralSecurityException("invalid Ed25519 public key", e);
        }
    }

    @Override
    public PublicKeyVerify getPrimitive(MessageLite key) throws GeneralSecurityException {
        if (!(key instanceof Ed25519PublicKey)) {
            throw new GeneralSecurityException("expected Ed25519PublicKey proto");
        }
        Ed25519PublicKey keyProto = (Ed25519PublicKey)key;
        this.validate(keyProto);
        return new Ed25519Verify(keyProto.getKeyValue().toByteArray());
    }

    @Override
    public MessageLite newKey(ByteString unused) throws GeneralSecurityException {
        throw new GeneralSecurityException("Not implemented");
    }

    @Override
    public MessageLite newKey(MessageLite unused) throws GeneralSecurityException {
        throw new GeneralSecurityException("Not implemented");
    }

    @Override
    public KeyData newKeyData(ByteString unused) throws GeneralSecurityException {
        throw new GeneralSecurityException("Not implemented");
    }

    @Override
    public boolean doesSupport(String typeUrl) {
        return TYPE_URL.equals(typeUrl);
    }

    @Override
    public String getKeyType() {
        return TYPE_URL;
    }

    @Override
    public int getVersion() {
        return 0;
    }

    private void validate(Ed25519PublicKey keyProto) throws GeneralSecurityException {
        Validators.validateVersion(keyProto.getVersion(), 0);
        if (keyProto.getKeyValue().size() != 32) {
            throw new GeneralSecurityException("invalid Ed25519 public key: incorrect key length");
        }
    }
}

