/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.hybrid;

import com.google.crypto.tink.Config;
import com.google.crypto.tink.Registry;
import com.google.crypto.tink.aead.AeadConfig;
import com.google.crypto.tink.hybrid.HybridDecryptCatalogue;
import com.google.crypto.tink.hybrid.HybridEncryptCatalogue;
import com.google.crypto.tink.proto.RegistryConfig;
import java.security.GeneralSecurityException;

public final class HybridConfig {
    public static final String ECIES_AEAD_HKDF_PUBLIC_KEY_TYPE_URL = "type.googleapis.com/google.crypto.tink.EciesAeadHkdfPublicKey";
    public static final String ECIES_AEAD_HKDF_PRIVATE_KEY_TYPE_URL = "type.googleapis.com/google.crypto.tink.EciesAeadHkdfPrivateKey";
    private static final String HYBRID_ENCRYPT_CATALOGUE_NAME = "TinkHybridEncrypt";
    private static final String HYBRID_DECRYPT_CATALOGUE_NAME = "TinkHybridDecrypt";
    @Deprecated
    public static final RegistryConfig TINK_1_0_0 = RegistryConfig.newBuilder().mergeFrom(AeadConfig.TINK_1_0_0).addEntry(Config.getTinkKeyTypeEntry("TinkHybridDecrypt", "HybridDecrypt", "EciesAeadHkdfPrivateKey", 0, true)).addEntry(Config.getTinkKeyTypeEntry("TinkHybridEncrypt", "HybridEncrypt", "EciesAeadHkdfPublicKey", 0, true)).setConfigName("TINK_HYBRID_1_0_0").build();
    @Deprecated
    public static final RegistryConfig TINK_1_1_0 = RegistryConfig.newBuilder().mergeFrom(TINK_1_0_0).setConfigName("TINK_HYBRID_1_1_0").build();
    public static final RegistryConfig LATEST = RegistryConfig.newBuilder().mergeFrom(AeadConfig.LATEST).addEntry(Config.getTinkKeyTypeEntry("TinkHybridDecrypt", "HybridDecrypt", "EciesAeadHkdfPrivateKey", 0, true)).addEntry(Config.getTinkKeyTypeEntry("TinkHybridEncrypt", "HybridEncrypt", "EciesAeadHkdfPublicKey", 0, true)).setConfigName("TINK_HYBRID").build();

    @Deprecated
    public static void init() throws GeneralSecurityException {
        HybridConfig.register();
    }

    public static void register() throws GeneralSecurityException {
        AeadConfig.register();
        Registry.addCatalogue(HYBRID_ENCRYPT_CATALOGUE_NAME, new HybridEncryptCatalogue());
        Registry.addCatalogue(HYBRID_DECRYPT_CATALOGUE_NAME, new HybridDecryptCatalogue());
        Config.register(LATEST);
    }

    static {
        try {
            HybridConfig.init();
        }
        catch (GeneralSecurityException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

