/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.xmlsig;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.apache.tsik.c14n.CanonicalizerFactory;
import org.apache.tsik.c14n.elements.InclusiveNamespacesElement;
import org.apache.tsik.common.Logger;
import org.apache.tsik.common.LoggerFactory;
import org.apache.tsik.domutil.DOMCursor;
import org.apache.tsik.domutil.DOMWriteCursor;
import org.apache.tsik.domutil.elements.ElementExtension;
import org.apache.tsik.uuid.UUID;
import org.apache.tsik.xmlsig.DSASigningKey;
import org.apache.tsik.xmlsig.HardwarePrivateKey;
import org.apache.tsik.xmlsig.HardwareSigningKey;
import org.apache.tsik.xmlsig.RSASigningKey;
import org.apache.tsik.xmlsig.SigningKey;
import org.apache.tsik.xmlsig.VerifyingKey;
import org.apache.tsik.xmlsig.elements.KeyInfo;
import org.apache.tsik.xmlsig.elements.ObjectElement;
import org.apache.tsik.xmlsig.elements.Reference;
import org.apache.tsik.xmlsig.elements.Signature;
import org.apache.tsik.xmlsig.elements.SignedInfo;
import org.apache.tsik.xmlsig.elements.transforms.CanonicalizationTransform;
import org.apache.tsik.xmlsig.elements.transforms.EnvelopedTransform;
import org.apache.tsik.xmlsig.elements.transforms.ExclusiveC14nTransform;
import org.apache.tsik.xpath.XPath;
import org.apache.tsik.xpath.XPathException;
import org.w3c.dom.Document;

public class Signer {
    private static Logger log = LoggerFactory.getLogger(class$org$apache$tsik$xmlsig$Signer == null ? (class$org$apache$tsik$xmlsig$Signer = Signer.class$("org.apache.tsik.xmlsig.Signer")) : class$org$apache$tsik$xmlsig$Signer);
    private Vector refs = new Vector();
    private DOMWriteCursor writeCursor = null;
    private Signature signature;
    private Document document;
    private List inclusivePrefixList = null;
    private boolean inPlace = false;
    static /* synthetic */ Class class$org$apache$tsik$xmlsig$Signer;

    public void useExclusiveCanonicalizer(List list) {
        if (list == null) {
            throw new IllegalArgumentException("list cannot be null");
        }
        if (log.isDebugEnabled()) {
            log.debug("using exclusive c14n, include prefix:" + list);
        }
        SignedInfo signedInfo = this.signature.getSignedInfo();
        signedInfo.useExclusiveCanonicalizer(list);
        this.inclusivePrefixList = new Vector(list);
    }

    public Signer(Document doc, PrivateKey signingKey, PublicKey verificationKey) throws InvalidKeyException, NoSuchAlgorithmException {
        this.create(doc, this.createSigningKey(signingKey), verificationKey);
    }

    public Signer(Document doc, PrivateKey signingKey) throws InvalidKeyException, NoSuchAlgorithmException {
        this.create(doc, this.createSigningKey(signingKey));
    }

    public Signer(Document doc, SigningKey signingKey) throws InvalidKeyException, NoSuchAlgorithmException {
        this.create(doc, signingKey);
    }

    public Signer(Document doc, SigningKey signingKey, VerifyingKey verifyingKey) throws InvalidKeyException, NoSuchAlgorithmException {
        this.create(doc, signingKey, verifyingKey);
    }

    public Signer(Document doc, PrivateKey signingKey, X509Certificate[] certificateChain) throws InvalidKeyException, NoSuchAlgorithmException, CertificateException {
        if (certificateChain == null || certificateChain[0] == null) {
            throw new IllegalArgumentException("certificate chain cannot be null");
        }
        this.create(doc, this.createSigningKey(signingKey));
        this.setCertificateChain(certificateChain);
    }

    public Signer(Document doc, PrivateKey signingKey, X509Certificate certificate) throws InvalidKeyException, NoSuchAlgorithmException, CertificateException {
        if (certificate == null) {
            throw new IllegalArgumentException("certificate cannot be null");
        }
        this.create(doc, this.createSigningKey(signingKey));
        this.setCertificate(certificate);
    }

    public Signer(Document doc, SigningKey signingKey, org.apache.tsik.xmlsig.KeyInfo keyInfo) throws InvalidKeyException, NoSuchAlgorithmException, CertificateException {
        this.create(doc, signingKey);
        this.setKeyInfo(keyInfo);
    }

    public Signer(Document doc, PrivateKey signingKey, org.apache.tsik.xmlsig.KeyInfo keyInfo) throws InvalidKeyException, NoSuchAlgorithmException, CertificateException {
        this.create(doc, this.createSigningKey(signingKey));
        this.setKeyInfo(keyInfo);
    }

    private void create(Document doc, SigningKey signingKey) throws InvalidKeyException, NoSuchAlgorithmException {
        this.create(doc, signingKey, (PublicKey)null);
    }

    private void create(Document doc, SigningKey signingKey, PublicKey verificationKey) throws InvalidKeyException, NoSuchAlgorithmException {
        this.createSignature(doc, signingKey);
        if (verificationKey != null) {
            KeyInfo keyInfo = this.signature.getKeyInfo();
            keyInfo.addKeyValue(verificationKey);
        }
    }

    private void createWriteCursor() {
        if (this.writeCursor != null) {
            return;
        }
        if (this.inPlace) {
            if (log.isDebugEnabled()) {
                log.debug("signing in place");
            }
            this.writeCursor = new DOMWriteCursor(this.document);
        } else {
            if (log.isDebugEnabled()) {
                log.debug("signing new document");
            }
            DOMCursor foo = new DOMCursor(this.document);
            this.writeCursor = new DOMWriteCursor();
            this.writeCursor.copyUnder(foo);
        }
    }

    private void create(Document doc, SigningKey signingKey, final VerifyingKey verifyingKey) throws InvalidKeyException, NoSuchAlgorithmException {
        this.createSignature(doc, signingKey);
        if (verifyingKey != null) {
            KeyInfo keyInfo = this.signature.getKeyInfo();
            keyInfo.setExtension(new ElementExtension(){

                public void toXml(DOMWriteCursor c) {
                    verifyingKey.writeKeyInfo(c.getElement());
                }

                public ElementExtension fromXml(DOMCursor cursor) {
                    return null;
                }
            });
        }
    }

    private void createSignature(Document doc, SigningKey signingKey) throws InvalidKeyException, NoSuchAlgorithmException {
        if (doc == null) {
            throw new IllegalArgumentException("document cannot be null");
        }
        this.document = doc;
        if (signingKey == null) {
            throw new IllegalArgumentException("signing key cannot be null");
        }
        this.signature = new Signature();
        this.signature.setSigningKey(signingKey);
    }

    /*
     * WARNING - void declaration
     */
    private SigningKey createSigningKey(PrivateKey signingKey) throws InvalidKeyException {
        void var2_2;
        SigningKey sigKey;
        if (signingKey instanceof RSAPrivateKey) {
            sigKey = new RSASigningKey(signingKey);
        } else if (signingKey instanceof DSAPrivateKey) {
            sigKey = new DSASigningKey(signingKey);
        } else if (signingKey instanceof HardwarePrivateKey) {
            sigKey = new HardwareSigningKey(signingKey);
        } else {
            throw new IllegalArgumentException("unknown signing key type");
        }
        return var2_2;
    }

    private void checkXPathExpression(XPath xpath) throws XPathException {
        String s = xpath.getXPath();
        if ("".equals(s)) {
            throw new XPathException("Empty XPath expression is not allowed");
        }
        if (s.indexOf("here()") != -1) {
            throw new XPathException("'here()' function cannot be used. Expression '" + s + "' is illegal.");
        }
        if (s.startsWith("..")) {
            throw new XPathException("Relative XPath expression '" + s + "' is not allowed");
        }
        DOMCursor foo = new DOMCursor(this.document);
        try {
            foo.moveToXPath(xpath);
        }
        catch (IllegalArgumentException e) {
            throw new XPathException(e.toString());
        }
    }

    public void addReference(XPath xpath) {
        this.refs.addElement(xpath);
    }

    private static void validateCertificate(X509Certificate certificate) throws CertificateException {
        if (certificate == null) {
            throw new IllegalArgumentException("certificate cannot be null");
        }
        certificate.checkValidity();
    }

    private static void validateCertificateChain(X509Certificate[] certificateChain) throws CertificateException {
        if (certificateChain == null) {
            throw new IllegalArgumentException("chain cannot be null");
        }
        if (certificateChain.length < 1) {
            throw new IllegalArgumentException("chain cannot be empty");
        }
        Signer.validateCertificate(certificateChain[0]);
        for (int i = 1; i < certificateChain.length; ++i) {
            if (certificateChain[i] == null) continue;
            Signer.validateCertificate(certificateChain[i]);
        }
    }

    private void setCertificate(X509Certificate certificate) throws CertificateException {
        Signer.validateCertificate(certificate);
        KeyInfo keyInfo = this.signature.getKeyInfo();
        keyInfo.addCertificate(certificate);
        keyInfo.explodeCertificate();
    }

    private void setKeyInfo(org.apache.tsik.xmlsig.KeyInfo keyInfo) throws CertificateException {
        if (keyInfo != null) {
            X509Certificate[] certChain = keyInfo.getCertificateChain();
            if (certChain != null) {
                Signer.validateCertificateChain(certChain);
            }
            this.signature.setKeyInfo(new KeyInfo(keyInfo));
        }
    }

    private void setCertificateChain(X509Certificate[] certificateChain) throws CertificateException {
        Signer.validateCertificateChain(certificateChain);
        KeyInfo keyInfo = this.signature.getKeyInfo();
        keyInfo.addCertificateChain(certificateChain);
        keyInfo.explodeCertificate();
    }

    private void addC14nTransform(Reference r) {
        if (this.inclusivePrefixList != null) {
            InclusiveNamespacesElement elemExt = new InclusiveNamespacesElement(this.inclusivePrefixList);
            ExclusiveC14nTransform t = new ExclusiveC14nTransform();
            t.setExtension(elemExt);
            r.addTransform(t);
        } else {
            r.addTransform(new CanonicalizationTransform());
        }
    }

    public void signInPlace() throws SignatureException, InvalidKeyException, NoSuchAlgorithmException, XPathException {
        this.inPlace = true;
        this.sign();
    }

    public Document sign() throws SignatureException, InvalidKeyException, NoSuchAlgorithmException, XPathException {
        boolean doTimes = log.isDebugEnabled();
        long startTime = 0L;
        if (doTimes) {
            startTime = System.currentTimeMillis();
        }
        this.createWriteCursor();
        int size = this.refs.size();
        if (size == 0) {
            XPath xp = new XPath("/*");
            this.addReference(xp);
        }
        Vector<DOMCursor> targets = new Vector<DOMCursor>();
        size = this.refs.size();
        for (int i = 0; i < size; ++i) {
            XPath xp = (XPath)this.refs.elementAt(i);
            this.checkXPathExpression(xp);
            DOMCursor c = this.writeCursor.cloneCursor();
            if (!c.moveToXPath(xp)) {
                throw new XPathException("XPath expression '" + xp.getXPath() + "'" + " evaluates to nothing");
            }
            targets.add(c);
        }
        SignedInfo signedInfo = this.signature.getSignedInfo();
        Enumeration enumer = targets.elements();
        int i = 1;
        while (enumer.hasMoreElements()) {
            DOMCursor c = (DOMCursor)enumer.nextElement();
            Reference r = new Reference();
            this.addC14nTransform(r);
            String id = UUID.generate().toString();
            ObjectElement o = new ObjectElement();
            o.setElementCursor(c);
            o.setId(id);
            r.setUri("#" + id);
            r.setTarget(o);
            signedInfo.addReference(r);
            ++i;
        }
        this.signature.addObjectsFromReferences(signedInfo.getReferences());
        signedInfo.calculateReferences();
        byte[] canon = signedInfo.canonicalize();
        SigningKey signingKey = this.signature.getSigningKey();
        byte[] bsig = signingKey.signData(canon);
        this.signature.setSignatureValue(bsig);
        if (log.isDebugEnabled()) {
            log.debug("sign=" + this.signature);
        }
        DOMWriteCursor tempCursor = new DOMWriteCursor();
        long t = 0L;
        if (doTimes) {
            t = System.currentTimeMillis();
        }
        this.signature.toXml(tempCursor);
        long toXmlTime = 0L;
        if (doTimes) {
            toXmlTime = System.currentTimeMillis() - t;
            t = System.currentTimeMillis();
        }
        if (this.inPlace) {
            this.writeCursor.moveToTop();
            this.writeCursor.remove();
            this.writeCursor.copyUnder(tempCursor);
        } else {
            this.writeCursor = tempCursor;
        }
        long elapsedTime = 0L;
        if (doTimes) {
            long copyTime = System.currentTimeMillis() - t;
            elapsedTime = System.currentTimeMillis() - startTime;
            log.debug("Time to sign: " + elapsedTime + " ms, of which toXml: " + toXmlTime + " copy: " + copyTime);
        }
        return this.writeCursor.getDocument();
    }

    public Document sign(XPath xpath) throws SignatureException, InvalidKeyException, NoSuchAlgorithmException, XPathException {
        return this.sign(xpath, false);
    }

    public void signInPlace(XPath xpath) throws SignatureException, InvalidKeyException, NoSuchAlgorithmException, XPathException {
        this.inPlace = true;
        this.sign(xpath, false);
    }

    public void signInPlace(XPath xpath, boolean insertBefore) throws SignatureException, InvalidKeyException, NoSuchAlgorithmException, XPathException {
        this.inPlace = true;
        this.sign(xpath, insertBefore);
    }

    public Document sign(XPath xpath, boolean insertBefore) throws SignatureException, InvalidKeyException, NoSuchAlgorithmException, XPathException {
        byte[] canon;
        DOMCursor c;
        boolean doTimes = log.isDebugEnabled();
        long startTime = 0L;
        if (doTimes) {
            startTime = System.currentTimeMillis();
        }
        this.createWriteCursor();
        this.writeCursor.moveToTop();
        this.checkXPathExpression(xpath);
        if (!this.writeCursor.moveToXPath(xpath)) {
            throw new XPathException("XPath expression '" + xpath.getXPath() + "'" + " evaluates to nothing");
        }
        int size = this.refs.size();
        if (size == 0) {
            XPath xp = new XPath("/");
            this.addReference(xp);
        }
        Vector<DOMCursor> targets = new Vector<DOMCursor>();
        Hashtable<DOMCursor, XPath> map = new Hashtable<DOMCursor, XPath>();
        size = this.refs.size();
        for (int i = 0; i < size; ++i) {
            XPath xp = (XPath)this.refs.elementAt(i);
            this.checkXPathExpression(xp);
            c = this.writeCursor.cloneCursor();
            if (!c.moveToXPath(xp)) {
                throw new XPathException("XPath expression '" + xp.getXPath() + "'" + " evaluates to nothing");
            }
            targets.add(c);
            map.put(c, xp);
        }
        SignedInfo signedInfo = this.signature.getSignedInfo();
        Enumeration enumer = targets.elements();
        while (enumer.hasMoreElements()) {
            c = (DOMCursor)enumer.nextElement();
            Reference r = new Reference();
            boolean needEnveloped = insertBefore ? !c.equals(this.writeCursor) && c.contains(this.writeCursor) : c.contains(this.writeCursor);
            if (needEnveloped) {
                if (log.isDebugEnabled()) {
                    log.debug("Adding enveloped transform");
                }
                r.addTransform(new EnvelopedTransform());
            }
            this.addC14nTransform(r);
            r.setTarget(c);
            XPath refXPath = (XPath)map.get(c);
            String foo = refXPath.getXPath();
            foo = "/".equals(foo) ? "" : refXPath.toXPointer();
            r.setUri(foo);
            signedInfo.addReference(r);
        }
        signedInfo.calculateReferences();
        if (CanonicalizerFactory.USE_OLD_IMPL) {
            DOMWriteCursor foo = new DOMWriteCursor();
            foo.copyUnder(this.writeCursor);
            foo = foo.addUnder(null, null, "temp");
            canon = signedInfo.canonicalize(foo);
        } else {
            canon = signedInfo.canonicalize(this.writeCursor);
        }
        if (log.isDebugEnabled()) {
            log.debug("canonical form = " + new String(canon));
        }
        SigningKey signingKey = this.signature.getSigningKey();
        byte[] bsig = signingKey.signData(canon);
        this.signature.setSignatureValue(bsig);
        if (log.isDebugEnabled()) {
            log.debug("sign=" + this.signature);
        }
        DOMWriteCursor wc = new DOMWriteCursor();
        long t = 0L;
        if (doTimes) {
            t = System.currentTimeMillis();
        }
        this.signature.toXml(wc);
        long toXmlTime = 0L;
        if (doTimes) {
            toXmlTime = System.currentTimeMillis() - t;
        }
        if (insertBefore) {
            this.writeCursor.copyBefore(wc);
        } else {
            this.writeCursor.copyUnder(wc);
        }
        if (doTimes) {
            long elapsedTime = System.currentTimeMillis() - startTime;
            log.debug("Time to sign: " + elapsedTime + " ms, of which toXml: " + toXmlTime);
        }
        return this.writeCursor.getDocument();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

