/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.xmlsig;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateKey;
import org.apache.tsik.xmlsig.SigningKey;

public class RSASigningKey
implements SigningKey {
    private static boolean DEBUG = false;
    private static String algorithmUri = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    private RSAPrivateKey privateKey;

    public RSASigningKey(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof RSAPrivateKey)) {
            throw new InvalidKeyException("Bad key type: " + privateKey);
        }
        this.privateKey = (RSAPrivateKey)privateKey;
    }

    public String getAlgorithmUri() {
        return algorithmUri;
    }

    public byte[] signData(byte[] data) throws SignatureException, InvalidKeyException, NoSuchAlgorithmException {
        try {
            Signature sig = Signature.getInstance("SHA1withRSA");
            sig.initSign(this.privateKey);
            sig.update(data);
            return sig.sign();
        }
        catch (NoSuchAlgorithmException nsae) {
            throw nsae;
        }
        catch (InvalidKeyException ike) {
            throw ike;
        }
        catch (SignatureException se) {
            throw se;
        }
    }

    public String toString() {
        return "[RSASigningKey]";
    }
}

