/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.wss.elements;

import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import org.apache.tsik.common.Logger;
import org.apache.tsik.common.LoggerFactory;
import org.apache.tsik.common.SchemaMapper;
import org.apache.tsik.domutil.DOMCursor;
import org.apache.tsik.domutil.DOMWriteCursor;
import org.apache.tsik.domutil.elements.ElementException;
import org.apache.tsik.domutil.elements.ElementImpl;
import org.apache.tsik.util.Namespaces;
import org.apache.tsik.wss.TokenResolver;
import org.apache.tsik.wss.elements.KeyIdentifier;
import org.apache.tsik.wss.elements.KeyInfo;
import org.apache.tsik.wss.elements.ReferenceList;
import org.apache.tsik.wss.elements.SecurityTokenReference;
import org.apache.tsik.xmlenc.AlgorithmType;
import org.apache.tsik.xmlenc.Encryptor;
import org.apache.tsik.xpath.XPathException;

public class EncryptedKey
extends ElementImpl {
    private static Class c = class$org$apache$tsik$wss$elements$EncryptedKey == null ? (class$org$apache$tsik$wss$elements$EncryptedKey = EncryptedKey.class$("org.apache.tsik.wss.elements.EncryptedKey")) : class$org$apache$tsik$wss$elements$EncryptedKey;
    private Logger log = LoggerFactory.getLogger(c);
    static String elementName = SchemaMapper.getName(c);
    static String prefix = Namespaces.XMLENC.getPrefix();
    public static String uri = Namespaces.XMLENC.getUri();
    private static String[] ns = new String[]{prefix, uri};
    private Key key;
    private org.apache.tsik.xmlenc.elements.EncryptedKey ek;
    private KeyInfo keyInfo;
    private ReferenceList refList;
    static /* synthetic */ Class class$org$apache$tsik$wss$elements$EncryptedKey;

    public EncryptedKey(KeyInfo keyInfo, ReferenceList refList) {
        this(null, keyInfo, refList);
    }

    private EncryptedKey(org.apache.tsik.xmlenc.elements.EncryptedKey ek, KeyInfo keyInfo, ReferenceList refList) {
        this.ek = ek;
        this.keyInfo = keyInfo;
        this.refList = refList;
    }

    public Key getDekKey() {
        return this.key;
    }

    public void encrypt(Key key) throws NoSuchAlgorithmException {
        this.encrypt(key, null);
    }

    public void encrypt(Key key, TokenResolver res) throws NoSuchAlgorithmException {
        this.key = key;
        DOMWriteCursor tmp = new DOMWriteCursor();
        tmp.addUnder("test", "test", "test");
        SecurityTokenReference str = this.keyInfo.getSecurityTokenReference();
        KeyIdentifier ki = str.getKeyIdentifier();
        X509Certificate cert = ki.getCertificate();
        if (cert == null) {
            cert = res.resolveCert(str);
        }
        Encryptor e = new Encryptor(tmp.getDocument(), cert.getPublicKey(), AlgorithmType.RSA1_5, null);
        try {
            e.encryptKeyInPlace(key, tmp.createXPath(), false);
        }
        catch (XPathException ex) {
            this.log.warn(ex.toString());
            ex.printStackTrace();
        }
        try {
            this.ek = org.apache.tsik.xmlenc.elements.EncryptedKey.fromXmlStatic(tmp);
        }
        catch (ElementException ex) {
            this.log.warn(ex.toString());
            ex.printStackTrace();
        }
    }

    public ReferenceList getReferenceList() {
        return this.refList;
    }

    public void toXml(DOMWriteCursor wc) {
        DOMWriteCursor tmp = new DOMWriteCursor();
        this.ek.toXml(tmp);
        DOMWriteCursor foo = new DOMWriteCursor();
        this.keyInfo.toXml(foo);
        tmp.moveToChild(Namespaces.XMLENC.getUri(), "CipherData");
        tmp.copyBefore(foo);
        tmp.moveToParent();
        this.refList.toXml(tmp);
        tmp.moveToParent();
        wc.copyUnder(tmp);
    }

    public static EncryptedKey fromXml(DOMCursor cursor) {
        DOMCursor c = EncryptedKey.placeCursor(cursor, elementName, prefix, uri, ns);
        org.apache.tsik.xmlenc.elements.EncryptedKey ek = null;
        KeyInfo keyInfo = null;
        ReferenceList refList = null;
        try {
            ek = org.apache.tsik.xmlenc.elements.EncryptedKey.fromXmlStatic(c);
        }
        catch (ElementException e) {
            e.printStackTrace();
        }
        if (c.moveToChild(Namespaces.XMLSIG.getUri(), "KeyInfo")) {
            keyInfo = KeyInfo.fromXml(c);
            c.moveToParent();
        }
        if (c.moveToChild(Namespaces.XMLENC.getUri(), "ReferenceList")) {
            refList = ReferenceList.fromXml(c);
            c.moveToParent();
        }
        return new EncryptedKey(ek, keyInfo, refList);
    }

    public String toString() {
        String s = "[EncryptedKey ";
        if (this.key != null) {
            s = s + " data encryption key=" + this.key;
        }
        if (this.ek != null) {
            s = s + " embedded EncryptedKey=" + this.ek;
        }
        if (this.keyInfo != null) {
            s = s + " keyInfo=" + this.keyInfo;
        }
        if (this.refList != null) {
            s = s + " referenceList=" + this.refList;
        }
        return s + "]";
    }

    public void decrypt(TokenResolver resolver) throws NoSuchAlgorithmException {
        this.log.debug(this);
        this.log.debug(resolver);
        Key key = resolver.resolveKey(this.keyInfo.getSecurityTokenReference());
        if (key == null) {
            throw new IllegalStateException("No key found for " + this.keyInfo.getSecurityTokenReference());
        }
        this.ek.setDecryptionKey(key);
        this.ek.decrypt();
        this.key = this.ek.getDecryptedKey();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

