/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.wss.actions;

import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import org.apache.tsik.util.Namespaces;
import org.apache.tsik.wsp.Action;
import org.apache.tsik.wsp.ActionViolation;
import org.apache.tsik.wss.DefaultTokenResolver;
import org.apache.tsik.wss.elements.EncryptedData;
import org.apache.tsik.wss.elements.EncryptedKey;
import org.apache.tsik.wss.elements.ReferenceList;
import org.apache.tsik.xmlenc.tools.ConversionException;
import org.apache.tsik.xpath.XPath;

public class DecryptBody
extends Action {
    private PrivateKey key;
    private X509Certificate cert;
    private XPath encKeyXpath;

    private boolean checkPreconditions() {
        this.key = this.getPrivateKey("key");
        this.cert = this.getX509Certificate("cert");
        this.encKeyXpath = this.getXPath("enckeyloc");
        if (this.key == null || this.cert == null || this.encKeyXpath == null) {
            return false;
        }
        return this.moveOutputToXPath(this.encKeyXpath);
    }

    public void execute() {
        if (!this.checkPreconditions()) {
            this.violations.add(new ActionViolation("Precond check failed"));
            return;
        }
        this.output.moveToXPath(this.encKeyXpath);
        EncryptedKey ek = EncryptedKey.fromXml(this.output);
        DefaultTokenResolver res = new DefaultTokenResolver();
        res.map(this.cert, (Key)this.key);
        try {
            ek.decrypt(res);
        }
        catch (NoSuchAlgorithmException ex) {
            this.violations.add(new ActionViolation((Exception)ex));
            return;
        }
        ReferenceList refList = ek.getReferenceList();
        String refId = refList.getDataReference();
        res.map(refId, ek.getDekKey());
        String[] ns = new String[]{"s", Namespaces.SOAPENV.getUri()};
        String s = "/s:Envelope/s:Body";
        XPath body = new XPath(s, ns);
        this.output.moveToXPath(body);
        this.output.moveToChild(1);
        EncryptedData ed = EncryptedData.fromXml(this.output);
        try {
            ed.decryptInPlace(this.output, res);
        }
        catch (ConversionException ex) {
            this.violations.add(new ActionViolation((Exception)ex));
            return;
        }
    }

    public boolean needsOutputDocument() {
        return true;
    }
}

