/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.resource;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.apache.tsik.resource.ResourceFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

class DOMSerializationV1 {
    public static final int VERSION = 1;
    int nextidx = 0;

    public void serialize(Node dom, OutputStream out) throws IOException {
        DataOutputStream dos = new DataOutputStream(out);
        this.serialize(dom, dos);
    }

    public void serialize(Node dom, DataOutput out) throws IOException {
        out.writeInt(1);
        this.serializeNode(-1, dom, out);
        out.writeShort(-1);
    }

    public Node deSerialize(InputStream in) throws IOException {
        DataInputStream din = new DataInputStream(in);
        return this.deSerialize(din);
    }

    public Node deSerialize(DataInput input) throws IOException {
        Vector accumulator = new Vector();
        while (this.deSerializeNode(input, accumulator) >= 0) {
        }
        if (((Document)accumulator.elementAt(0)).getNodeName().equals("fake")) {
            return (Node)accumulator.elementAt(1);
        }
        return (Document)accumulator.elementAt(0);
    }

    private short deSerializeNode(DataInput input, Vector nodes) throws IOException {
        short type;
        try {
            type = input.readShort();
        }
        catch (EOFException eof) {
            return -1;
        }
        if (type < 0) {
            return type;
        }
        int nodeidx = input.readInt();
        int parentidx = input.readInt();
        String name = this.readString(input);
        String value = this.readString(input);
        if (nodes.size() <= nodeidx) {
            nodes.setSize(nodeidx + 1);
        }
        if (nodeidx == 0 && type != 9) {
            throw new IOException("Stream must begin with document element");
        }
        Document doc = null;
        if (nodes.size() > 0) {
            doc = (Document)nodes.elementAt(0);
        }
        switch (type) {
            case 2: {
                Attr attr = doc.createAttribute(name);
                attr.setValue(value);
                nodes.setElementAt(attr, nodeidx);
                Node nd = (Node)nodes.elementAt(parentidx);
                if (nd instanceof Element) {
                    ((Element)nd).setAttributeNode(attr);
                    break;
                }
                nd.appendChild(attr);
                break;
            }
            case 4: {
                CDATASection cdat = doc.createCDATASection(value);
                nodes.setElementAt(cdat, nodeidx);
                Node node = (Node)nodes.elementAt(parentidx);
                node.appendChild(cdat);
                break;
            }
            case 8: {
                Comment comt = doc.createComment(value);
                nodes.setElementAt(comt, nodeidx);
                Node node = (Node)nodes.elementAt(parentidx);
                node.appendChild(comt);
                break;
            }
            case 11: {
                throw new IOException("Document Fragment in deserialized DOM ??? ");
            }
            case 9: {
                doc = ResourceFactory.getXMLResource().createDocument();
                nodes.setElementAt(doc, nodeidx);
                break;
            }
            case 10: {
                throw new IOException("Document Type currently unsupported in serialized DOMs");
            }
            case 1: {
                Element el = doc.createElement(name);
                nodes.setElementAt(el, nodeidx);
                Node node = (Node)nodes.elementAt(parentidx);
                node.appendChild(el);
                break;
            }
            case 6: {
                throw new IOException("Document Entities currently unsupported in serialized DOMs");
            }
            case 5: {
                EntityReference ref = doc.createEntityReference(name);
                nodes.setElementAt(ref, nodeidx);
                Node node = (Node)nodes.elementAt(parentidx);
                node.appendChild(ref);
                break;
            }
            case 12: {
                throw new IOException("Notations currently unsupported in serialized DOMs");
            }
            case 7: {
                String data = this.readString(input);
                String target = this.readString(input);
                ProcessingInstruction pi = doc.createProcessingInstruction(target, data);
                nodes.setElementAt(pi, nodeidx);
                Node node = (Node)nodes.elementAt(parentidx);
                node.appendChild(pi);
                break;
            }
            case 3: {
                Text tx = doc.createTextNode(value);
                nodes.setElementAt(tx, nodeidx);
                Node node = (Node)nodes.elementAt(parentidx);
                if (!(node instanceof Element)) break;
                node.appendChild(tx);
                break;
            }
        }
        return 0;
    }

    private void serializeNode(int parentidx, Node dom, DataOutput out) throws IOException {
        int myidx = this.nextidx++;
        short type = dom.getNodeType();
        if (myidx == 0 && type != 9) {
            out.writeShort(9);
            out.writeInt(myidx);
            out.writeInt(parentidx);
            this.writeString("fake", out);
            this.writeString(null, out);
            parentidx = myidx;
            myidx = this.nextidx++;
        }
        this.serializeSingleNode(myidx, parentidx, dom, out);
        NamedNodeMap attrs = dom.getAttributes();
        if (attrs != null) {
            int sz = attrs.getLength();
            for (int i = 0; i < sz; ++i) {
                this.serializeNode(myidx, attrs.item(i), out);
            }
        }
        for (Node child = dom.getFirstChild(); child != null; child = child.getNextSibling()) {
            this.serializeNode(myidx, child, out);
        }
    }

    private void serializeSingleNode(int myidx, int parentidx, Node dom, DataOutput out) throws IOException {
        short type = dom.getNodeType();
        if (type == 3 && dom.getParentNode().getNodeType() != 1) {
            return;
        }
        out.writeShort(type);
        out.writeInt(myidx);
        out.writeInt(parentidx);
        this.writeString(dom.getNodeName(), out);
        this.writeString(dom.getNodeValue(), out);
        switch (type) {
            case 12: {
                this.writeString(((Notation)dom).getPublicId(), out);
                this.writeString(((Notation)dom).getSystemId(), out);
                break;
            }
            case 7: {
                this.writeString(((ProcessingInstruction)dom).getData(), out);
                this.writeString(((ProcessingInstruction)dom).getTarget(), out);
            }
        }
    }

    public InputStream getSerializationStream(Node node) throws IOException {
        throw new IOException("Unsupported Version");
    }

    private void writeString(String s, DataOutput out) throws IOException {
        if (s == null) {
            out.writeByte(-1);
            return;
        }
        if (s.length() == 0) {
            out.writeByte(0);
            return;
        }
        out.writeByte(1);
        out.writeUTF(s);
    }

    private String readString(DataInput in) throws IOException {
        byte b = in.readByte();
        if (b < 0) {
            return null;
        }
        if (b == 0) {
            return "";
        }
        return in.readUTF();
    }
}

