/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.datatypes;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class Base64 {
    private static final String base64String = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
    private static final char[] base64Digits = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".toCharArray();
    private static final byte[] base64Values = Base64.getBase64Values();
    private static final int MAX_LINE_LENGTH = 72;

    private static byte[] getBase64Values() {
        byte[] result = new byte[125];
        Arrays.fill(result, (byte)-1);
        for (int i = 0; i < base64Digits.length; i = (int)((byte)(i + 1))) {
            result[Base64.base64Digits[i]] = i;
        }
        return result;
    }

    private Base64() {
    }

    private static ByteArrayOutputStream getBAOS(int initialLength) {
        return new ByteArrayOutputStream(initialLength);
    }

    private static void releaseBAOS(ByteArrayOutputStream baos) {
        try {
            baos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static byte[] decode(String encoded) {
        ByteArrayOutputStream baos = Base64.getBAOS(encoded.length() * 6 / 8 + 3);
        int buffer = 0;
        int goodBits = 0;
        for (int i = 0; i < encoded.length(); ++i) {
            byte value;
            char ch = encoded.charAt(i);
            if (ch >= base64Values.length || (value = base64Values[ch]) < 0) continue;
            if (value >= 64) break;
            buffer <<= 6;
            buffer |= value;
            if ((goodBits += 6) < 8) continue;
            baos.write(buffer >> goodBits - 8 & 0xFF);
            goodBits -= 8;
        }
        byte[] result = baos.toByteArray();
        Base64.releaseBAOS(baos);
        return result;
    }

    public static String encode(byte[] data) {
        return Base64.encode(data, 72, "\n");
    }

    private static String encode(byte[] data, int maxLineLength, String lineSeparator) {
        if (lineSeparator == null) {
            lineSeparator = "";
        }
        StringBuffer result = new StringBuffer();
        int buffer = 0;
        int goodBits = 0;
        int lineLen = 0;
        for (int i = 0; i < data.length; ++i) {
            buffer = buffer << 8 | data[i] & 0xFF;
            goodBits += 8;
            while (goodBits >= 6) {
                int value = buffer >> goodBits - 6 & 0x3F;
                result.append(base64Digits[value]);
                goodBits -= 6;
                if (++lineLen < maxLineLength) continue;
                lineLen = 0;
                result.append(lineSeparator);
            }
        }
        if (goodBits > 0) {
            int value = buffer << 6 - goodBits & 0x3F;
            result.append(base64Digits[value]);
            ++lineLen;
        }
        switch (lineLen % 4) {
            case 0: {
                break;
            }
            case 1: {
                result.append("===");
                break;
            }
            case 2: {
                result.append("==");
                break;
            }
            case 3: {
                result.append("=");
            }
        }
        return result.toString();
    }
}

