/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IPAddressHelper {
    private static Logger log = LoggerFactory.getLogger(IPAddressHelper.class);

    private IPAddressHelper() {
    }

    public static String addressToString(byte[] address) {
        if (IPAddressHelper.isIPv4(address)) {
            return IPAddressHelper.ipv4ToString(address);
        }
        if (IPAddressHelper.isIPv6(address)) {
            return IPAddressHelper.ipv6ToString(address);
        }
        log.error("IP address byte array was an invalid length: {}", (Object)address.length);
        return null;
    }

    private static String ipv4ToString(byte[] address) {
        StringBuilder builder = new StringBuilder();
        byte[] ip = new byte[4];
        System.arraycopy(address, 0, ip, 0, 4);
        try {
            builder.append(InetAddress.getByAddress(ip).getHostAddress());
        }
        catch (UnknownHostException e) {
            log.error("Unknown host exception processing IP address byte array: {}", (Object)e.getMessage());
            return null;
        }
        if (IPAddressHelper.hasMask(address)) {
            byte[] mask = new byte[4];
            System.arraycopy(address, 4, mask, 0, 4);
            builder.append("/");
            try {
                builder.append(InetAddress.getByAddress(mask).getHostAddress());
            }
            catch (UnknownHostException e) {
                log.error("Unknown host exception processing IP address byte array: {}", (Object)e.getMessage());
                return null;
            }
        }
        return builder.toString();
    }

    private static String ipv6ToString(byte[] address) {
        StringBuilder builder = new StringBuilder();
        byte[] ip = new byte[16];
        System.arraycopy(address, 0, ip, 0, 16);
        try {
            builder.append(InetAddress.getByAddress(ip).getHostAddress());
        }
        catch (UnknownHostException e) {
            log.error("Unknown host exception processing IP address byte array: {}", (Object)e.getMessage());
            return null;
        }
        if (IPAddressHelper.hasMask(address)) {
            log.error("IPv6 subnet masks are currently unsupported");
            return null;
        }
        return builder.toString();
    }

    public static boolean isIPv4(byte[] address) {
        return address.length == 4 || address.length == 8;
    }

    public static boolean isIPv6(byte[] address) {
        return address.length == 16 || address.length == 32;
    }

    public static boolean hasMask(byte[] address) {
        return address.length == 8 || address.length == 32;
    }
}

