/*
 * Decompiled with CFR 0.152.
 */
package org.maxkey.authz.saml20.provider.xml;

import java.util.Collection;
import java.util.HashMap;
import org.joda.time.DateTime;
import org.maxkey.authz.saml.common.AuthnRequestInfo;
import org.maxkey.authz.saml.service.IDService;
import org.maxkey.authz.saml.service.TimeService;
import org.maxkey.authz.saml20.provider.xml.AssertionGenerator;
import org.maxkey.authz.saml20.provider.xml.StatusGenerator;
import org.maxkey.authz.saml20.xml.IssuerGenerator;
import org.maxkey.constants.BOOLEAN;
import org.maxkey.domain.apps.AppsSAML20Details;
import org.opensaml.Configuration;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.EncryptedAssertion;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.Response;
import org.opensaml.saml2.core.impl.ResponseBuilder;
import org.opensaml.saml2.encryption.Encrypter;
import org.opensaml.xml.XMLObjectBuilderFactory;
import org.opensaml.xml.encryption.EncryptionException;
import org.opensaml.xml.encryption.EncryptionParameters;
import org.opensaml.xml.encryption.KeyEncryptionParameters;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.keyinfo.KeyInfoGeneratorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.GrantedAuthority;

public class AuthnResponseGenerator {
    private static final Logger logger = LoggerFactory.getLogger(AuthnResponseGenerator.class);
    private final XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();
    private String issuerName;
    private IDService idService;
    private TimeService timeService;
    private AssertionGenerator assertionGenerator;
    private IssuerGenerator issuerGenerator;
    private StatusGenerator statusGenerator;

    public AuthnResponseGenerator(String issuerName, TimeService timeService, IDService idService) {
        this.issuerName = issuerName;
        this.idService = idService;
        this.timeService = timeService;
        this.issuerGenerator = new IssuerGenerator(issuerName);
        this.assertionGenerator = new AssertionGenerator(issuerName, timeService, idService);
        this.statusGenerator = new StatusGenerator();
    }

    public Response generateAuthnResponse(AppsSAML20Details saml20Details, AuthnRequestInfo authnRequestInfo, String nameIdValue, String clientAddress, DateTime authnInstant, Collection<GrantedAuthority> authorities, HashMap<String, String> attributeMap, Credential signingCredential, Credential spSigningCredential) {
        ResponseBuilder responseBuilder = (ResponseBuilder)this.builderFactory.getBuilder(Response.DEFAULT_ELEMENT_NAME);
        Response authResponse = responseBuilder.buildObject();
        int validInSeconds = Integer.parseInt(saml20Details.getValidityInterval());
        String audienceUrl = saml20Details.getAudience();
        String assertionConsumerURL = saml20Details.getSpAcsUrl();
        String inResponseTo = authnRequestInfo.getAuthnRequestID();
        Issuer responseIssuer = this.issuerGenerator.generateIssuer();
        Assertion assertion = this.assertionGenerator.generateAssertion(assertionConsumerURL, nameIdValue, inResponseTo, audienceUrl, validInSeconds, authorities, attributeMap, clientAddress, authnInstant);
        try {
            if (BOOLEAN.isTrue((int)saml20Details.getEncrypted())) {
                logger.info("begin to encrypt assertion");
                EncryptionParameters encryptionParameters = new EncryptionParameters();
                encryptionParameters.setAlgorithm("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
                logger.info("encryption assertion Algorithm : http://www.w3.org/2001/04/xmlenc#aes128-cbc");
                KeyEncryptionParameters keyEncryptionParameters = new KeyEncryptionParameters();
                keyEncryptionParameters.setEncryptionCredential(spSigningCredential);
                keyEncryptionParameters.setAlgorithm("http://www.w3.org/2001/04/xmlenc#rsa-1_5");
                logger.info("keyEncryption  Algorithm : http://www.w3.org/2001/04/xmlenc#rsa-1_5");
                KeyInfoGeneratorFactory keyInfoGeneratorFactory = Configuration.getGlobalSecurityConfiguration().getKeyInfoGeneratorManager().getDefaultManager().getFactory(spSigningCredential);
                keyEncryptionParameters.setKeyInfoGenerator(keyInfoGeneratorFactory.newInstance());
                Encrypter encrypter = new Encrypter(encryptionParameters, keyEncryptionParameters);
                encrypter.setKeyPlacement(Encrypter.KeyPlacement.PEER);
                EncryptedAssertion encryptedAssertion = encrypter.encrypt(assertion);
                authResponse.getEncryptedAssertions().add(encryptedAssertion);
            } else {
                authResponse.getAssertions().add(assertion);
            }
        }
        catch (EncryptionException e) {
            logger.info("Unable to encrypt assertion .");
            e.printStackTrace();
        }
        authResponse.setIssuer(responseIssuer);
        authResponse.setID(this.idService.generateID());
        authResponse.setIssueInstant(this.timeService.getCurrentDateTime());
        authResponse.setInResponseTo(inResponseTo);
        authResponse.getAssertions().add(assertion);
        authResponse.setDestination(assertionConsumerURL);
        authResponse.setStatus(this.statusGenerator.generateStatus("urn:oasis:names:tc:SAML:2.0:status:Success"));
        return authResponse;
    }
}

