/*
 * Decompiled with CFR 0.152.
 */
package org.maxkey.authz.saml20.metadata;

import java.security.KeyStore;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.maxkey.authz.saml.common.TrustResolver;
import org.maxkey.crypto.keystore.KeyStoreLoader;
import org.opensaml.Configuration;
import org.opensaml.DefaultBootstrap;
import org.opensaml.common.SAMLObjectBuilder;
import org.opensaml.common.binding.security.IssueInstantRule;
import org.opensaml.common.binding.security.MessageReplayRule;
import org.opensaml.saml2.metadata.Company;
import org.opensaml.saml2.metadata.ContactPerson;
import org.opensaml.saml2.metadata.ContactPersonTypeEnumeration;
import org.opensaml.saml2.metadata.EmailAddress;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.GivenName;
import org.opensaml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml2.metadata.LocalizedString;
import org.opensaml.saml2.metadata.ManageNameIDService;
import org.opensaml.saml2.metadata.NameIDFormat;
import org.opensaml.saml2.metadata.Organization;
import org.opensaml.saml2.metadata.OrganizationDisplayName;
import org.opensaml.saml2.metadata.OrganizationName;
import org.opensaml.saml2.metadata.OrganizationURL;
import org.opensaml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml2.metadata.SingleLogoutService;
import org.opensaml.saml2.metadata.SingleSignOnService;
import org.opensaml.saml2.metadata.SurName;
import org.opensaml.saml2.metadata.TelephoneNumber;
import org.opensaml.saml2.metadata.impl.CompanyBuilder;
import org.opensaml.saml2.metadata.impl.EmailAddressBuilder;
import org.opensaml.saml2.metadata.impl.GivenNameBuilder;
import org.opensaml.saml2.metadata.impl.OrganizationBuilder;
import org.opensaml.saml2.metadata.impl.OrganizationDisplayNameBuilder;
import org.opensaml.saml2.metadata.impl.OrganizationNameBuilder;
import org.opensaml.saml2.metadata.impl.OrganizationURLBuilder;
import org.opensaml.saml2.metadata.impl.SurNameBuilder;
import org.opensaml.saml2.metadata.impl.TelephoneNumberBuilder;
import org.opensaml.util.storage.MapBasedStorageService;
import org.opensaml.util.storage.ReplayCache;
import org.opensaml.util.storage.StorageService;
import org.opensaml.xml.ConfigurationException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.XMLObjectBuilder;
import org.opensaml.xml.XMLObjectBuilderFactory;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallerFactory;
import org.opensaml.xml.io.Unmarshaller;
import org.opensaml.xml.io.UnmarshallerFactory;
import org.opensaml.xml.io.UnmarshallingException;
import org.opensaml.xml.parse.BasicParserPool;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.credential.KeyStoreCredentialResolver;
import org.opensaml.xml.security.credential.UsageType;
import org.opensaml.xml.security.criteria.EntityIDCriteria;
import org.opensaml.xml.security.criteria.UsageCriteria;
import org.opensaml.xml.security.keyinfo.KeyInfoGenerator;
import org.opensaml.xml.security.x509.X509KeyInfoGeneratorFactory;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MetadataGenerator {
    private static final Logger logger = LoggerFactory.getLogger(MetadataGenerator.class);
    protected static BasicParserPool parser;
    protected static XMLObjectBuilderFactory builderFactory;
    protected static MarshallerFactory marshallerFactory;
    protected static UnmarshallerFactory unmarshallerFactory;
    private static Logger log;

    public static void main(String[] args) {
        MetadataGenerator metadataGenerator = new MetadataGenerator();
        metadataGenerator.samlmtest();
    }

    public void samlmtest() {
        try {
            XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();
            KeyStoreLoader keyStoreLoader = new KeyStoreLoader();
            keyStoreLoader.setKeystorePassword("secret");
            keyStoreLoader.setKeystoreFile("D:/JavaIDE/cert/idp-keystore.jks");
            keyStoreLoader.afterPropertiesSet();
            KeyStore trustKeyStore = keyStoreLoader.getKeyStore();
            IssueInstantRule issueInstantRule = new IssueInstantRule(90, 300);
            ReplayCache replayCache = new ReplayCache((StorageService)new MapBasedStorageService(), 14400000L);
            MessageReplayRule messageReplayRule = new MessageReplayRule(replayCache);
            TrustResolver trustResolver = new TrustResolver(trustKeyStore, "idp", keyStoreLoader.getKeystorePassword(), issueInstantRule, messageReplayRule, "POST");
            KeyStoreCredentialResolver credentialResolver = trustResolver.getKeyStoreCredentialResolver();
            CriteriaSet criteriaSet = new CriteriaSet();
            criteriaSet.add((Object)new EntityIDCriteria("idp"));
            criteriaSet.add((Object)new UsageCriteria(UsageType.SIGNING));
            Credential signingCredential = null;
            try {
                signingCredential = (Credential)credentialResolver.resolveSingle((Object)criteriaSet);
            }
            catch (SecurityException e) {
                System.out.println("Credential resolve error : " + (Object)((Object)e));
                throw new Exception(e);
            }
            IDPSSODescriptor descriptor = this.buildIDPSSODescriptor();
            descriptor.getSingleSignOnServices().add(this.getSingleSignOnService("http://www.qoros.com/sso", null));
            descriptor.getSingleSignOnServices().add(this.getSingleSignOnService("http://www.qoros.com/sso", "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign"));
            descriptor.getSingleLogoutServices().add(this.getSingleLogoutService("http://www.qoros.com/slo", null));
            descriptor.getKeyDescriptors().add(this.generateEncryptionKeyDescriptor(signingCredential));
            descriptor.getKeyDescriptors().add(this.generateSignKeyDescriptor(signingCredential));
            descriptor.getNameIDFormats().add(this.generateNameIDFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:transient"));
            descriptor.getNameIDFormats().add(this.generateNameIDFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent"));
            descriptor.getNameIDFormats().add(this.generateNameIDFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress"));
            descriptor.getNameIDFormats().add(this.generateNameIDFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:entity"));
            descriptor.getContactPersons().add(this.getContactPerson("qoros", "shi", "ming", "shimh@connsec.com", "18724229876", null));
            descriptor.setOrganization(this.getOrganization("qoros", "qorosc", "http://www.qoros.com"));
            String entityId = "http://www.test.com";
            EntityDescriptor entityDescriptor = this.buildEntityDescriptor(entityId, (RoleDescriptor)descriptor);
            String descriptorelementxml = XMLHelper.prettyPrintXML((Node)this.marshallerMetadata(entityDescriptor));
            System.out.println("descriptor elementxm:\\n");
            System.out.println(descriptorelementxml);
            logger.info(descriptorelementxml);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public IDPSSODescriptor buildIDPSSODescriptor() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "IDPSSODescriptor", "md");
        IDPSSODescriptor idpSSODescriptor = (IDPSSODescriptor)MetadataGenerator.buildXMLObject(qname);
        idpSSODescriptor.addSupportedProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        return idpSSODescriptor;
    }

    public EntityDescriptor buildEntityDescriptor(String entityId, RoleDescriptor roleDescriptor) {
        SAMLObjectBuilder builder = (SAMLObjectBuilder)builderFactory.getBuilder(EntityDescriptor.DEFAULT_ELEMENT_NAME);
        EntityDescriptor entityDescriptor = (EntityDescriptor)builder.buildObject();
        entityDescriptor.setEntityID(entityId);
        entityDescriptor.getRoleDescriptors().add(roleDescriptor);
        return entityDescriptor;
    }

    public Document marshallerMetadata(EntityDescriptor entityDescriptor) {
        Document document = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            document = documentBuilder.newDocument();
            Marshaller marshaller = marshallerFactory.getMarshaller((XMLObject)entityDescriptor);
            marshaller.marshall((XMLObject)entityDescriptor, document);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return document;
    }

    public ManageNameIDService getManageNameIDService(String url) {
        QName manageNameIDServiceQName = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "ManageNameIDService", "md");
        ManageNameIDService manageNameIDService = (ManageNameIDService)MetadataGenerator.buildXMLObject(manageNameIDServiceQName);
        manageNameIDService.setLocation(url);
        manageNameIDService.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        return null;
    }

    public Organization getOrganization(String name, String displayName, String url) {
        Organization organization = new OrganizationBuilder().buildObject();
        OrganizationName organizationName = new OrganizationNameBuilder().buildObject();
        LocalizedString orglocalizedString = new LocalizedString();
        orglocalizedString.setLocalizedString(name);
        organizationName.setName(orglocalizedString);
        organization.getOrganizationNames().add(organizationName);
        OrganizationDisplayName organizationDisplayName = new OrganizationDisplayNameBuilder().buildObject();
        LocalizedString localizedString = new LocalizedString();
        localizedString.setLocalizedString(displayName);
        organizationDisplayName.setName(localizedString);
        organization.getDisplayNames().add(organizationDisplayName);
        OrganizationURL organizationURL = new OrganizationURLBuilder().buildObject();
        LocalizedString urllocalizedString = new LocalizedString();
        urllocalizedString.setLocalizedString(url);
        organizationURL.setURL(urllocalizedString);
        organization.getURLs().add(organizationURL);
        return organization;
    }

    public ContactPerson getContactPerson(String companyName, String givenName, String surName, String emailAddress, String telephoneNumber, ContactPersonTypeEnumeration contactPersonType) {
        QName contactQName = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "ContactPerson", "md");
        ContactPerson contactPerson = (ContactPerson)MetadataGenerator.buildXMLObject(contactQName);
        contactPerson.setType(contactPersonType);
        Company company = new CompanyBuilder().buildObject();
        company.setName(companyName);
        contactPerson.setCompany(company);
        GivenName contactPersonGivenName = new GivenNameBuilder().buildObject();
        contactPersonGivenName.setName(givenName);
        contactPerson.setGivenName(contactPersonGivenName);
        SurName contactPersonSurName = new SurNameBuilder().buildObject();
        contactPersonSurName.setName(surName);
        contactPerson.setSurName(contactPersonSurName);
        EmailAddress contactPersonEmailAddress = new EmailAddressBuilder().buildObject();
        contactPersonEmailAddress.setAddress(emailAddress);
        contactPerson.getEmailAddresses().add(contactPersonEmailAddress);
        TelephoneNumber contactPersonTelephoneNumber = new TelephoneNumberBuilder().buildObject();
        contactPersonTelephoneNumber.setNumber(telephoneNumber);
        contactPerson.getTelephoneNumbers().add(contactPersonTelephoneNumber);
        return contactPerson;
    }

    public SingleSignOnService getSingleSignOnService(String location, String binding) {
        QName ssoQName = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "SingleSignOnService", "md");
        SingleSignOnService singleSignOnService = (SingleSignOnService)MetadataGenerator.buildXMLObject(ssoQName);
        if (binding == null) {
            binding = "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST";
        }
        singleSignOnService.setBinding(binding);
        singleSignOnService.setLocation(location);
        return singleSignOnService;
    }

    public SingleLogoutService getSingleLogoutService(String location, String binding) {
        QName sloQName = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "SingleLogoutService", "md");
        SingleLogoutService singleLogoutService = (SingleLogoutService)MetadataGenerator.buildXMLObject(sloQName);
        if (binding == null) {
            binding = "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect";
        }
        singleLogoutService.setBinding(binding);
        singleLogoutService.setLocation(location);
        return singleLogoutService;
    }

    public NameIDFormat generateNameIDFormat(String nameIDType) {
        NameIDFormat nameIDFormat = (NameIDFormat)((SAMLObjectBuilder)builderFactory.getBuilder(NameIDFormat.DEFAULT_ELEMENT_NAME)).buildObject();
        nameIDFormat.setFormat(nameIDType);
        return nameIDFormat;
    }

    public KeyInfoGenerator getKeyInfoGenerator() {
        X509KeyInfoGeneratorFactory keyInfoGeneratorFactory = new X509KeyInfoGeneratorFactory();
        keyInfoGeneratorFactory.setEmitEntityCertificate(true);
        KeyInfoGenerator keyInfoGenerator = keyInfoGeneratorFactory.newInstance();
        return keyInfoGenerator;
    }

    public KeyDescriptor generateSignKeyDescriptor(Credential signingCredential) {
        KeyDescriptor signKeyDescriptor = (KeyDescriptor)((SAMLObjectBuilder)builderFactory.getBuilder(KeyDescriptor.DEFAULT_ELEMENT_NAME)).buildObject();
        signKeyDescriptor.setUse(UsageType.SIGNING);
        try {
            signKeyDescriptor.setKeyInfo(this.getKeyInfoGenerator().generate(signingCredential));
        }
        catch (SecurityException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return signKeyDescriptor;
    }

    public KeyDescriptor generateEncryptionKeyDescriptor(Credential signingCredential) {
        KeyDescriptor encryptionKeyDescriptor = (KeyDescriptor)((SAMLObjectBuilder)builderFactory.getBuilder(KeyDescriptor.DEFAULT_ELEMENT_NAME)).buildObject();
        encryptionKeyDescriptor.setUse(UsageType.ENCRYPTION);
        try {
            encryptionKeyDescriptor.setKeyInfo(this.getKeyInfoGenerator().generate(signingCredential));
        }
        catch (SecurityException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return encryptionKeyDescriptor;
    }

    public static XMLObject buildXMLObject(QName objectQName) {
        XMLObjectBuilder builder = builderFactory.getBuilder(objectQName);
        if (builder == null) {
            // empty if block
        }
        return builder.buildObject(objectQName.getNamespaceURI(), objectQName.getLocalPart(), objectQName.getPrefix());
    }

    protected static XMLObject unmarshallElement(Document doc) {
        try {
            Element samlElement = doc.getDocumentElement();
            Unmarshaller unmarshaller = org.opensaml.xml.Configuration.getUnmarshallerFactory().getUnmarshaller(samlElement);
            if (unmarshaller == null) {
                // empty if block
            }
            return unmarshaller.unmarshall(samlElement);
        }
        catch (UnmarshallingException unmarshallingException) {
            return null;
        }
    }

    public static Element marshallerElement(XMLObject xmlObject) {
        Marshaller marshaller = marshallerFactory.getMarshaller(xmlObject);
        if (marshaller == null) {
            // empty if block
        }
        Element generatedDOM = null;
        try {
            generatedDOM = marshaller.marshall(xmlObject, parser.newDocument());
            if (log.isDebugEnabled()) {
                log.debug("Marshalled DOM was " + XMLHelper.nodeToString((Node)generatedDOM));
            }
        }
        catch (Exception e) {
            log.error("Marshalling failed with the following error:", (Throwable)e);
        }
        return generatedDOM;
    }

    public MetadataGenerator() {
        parser = new BasicParserPool();
        parser.setNamespaceAware(true);
        try {
            DefaultBootstrap.bootstrap();
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
        builderFactory = org.opensaml.xml.Configuration.getBuilderFactory();
        marshallerFactory = org.opensaml.xml.Configuration.getMarshallerFactory();
        unmarshallerFactory = org.opensaml.xml.Configuration.getUnmarshallerFactory();
    }

    static {
        log = LoggerFactory.getLogger(MetadataGenerator.class);
    }
}

