/*
 * Decompiled with CFR 0.152.
 */
package org.maxkey.authz.saml20.consumer.endpoint;

import java.io.ByteArrayInputStream;
import java.security.KeyStore;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.maxkey.authz.saml.common.EndpointGenerator;
import org.maxkey.authz.saml.common.TrustResolver;
import org.maxkey.authz.saml.service.IDService;
import org.maxkey.authz.saml.service.TimeService;
import org.maxkey.authz.saml20.ExtractBindingAdapter;
import org.maxkey.authz.saml20.consumer.AuthnRequestGenerator;
import org.maxkey.authz.saml20.consumer.spring.IdentityProviderAuthenticationException;
import org.maxkey.authz.saml20.consumer.spring.ServiceProviderAuthenticationException;
import org.maxkey.authz.saml20.provider.xml.AuthnResponseGenerator;
import org.maxkey.authz.saml20.xml.SAML2ValidatorSuite;
import org.maxkey.crypto.keystore.KeyStoreLoader;
import org.maxkey.dao.service.AppsSaml20DetailsService;
import org.maxkey.domain.apps.AppsSAML20Details;
import org.maxkey.web.WebContext;
import org.opensaml.common.binding.security.IssueInstantRule;
import org.opensaml.common.binding.security.MessageReplayRule;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Response;
import org.opensaml.ws.security.SecurityPolicyResolver;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.credential.CredentialResolver;
import org.opensaml.xml.security.credential.KeyStoreCredentialResolver;
import org.opensaml.xml.security.credential.UsageType;
import org.opensaml.xml.security.criteria.EntityIDCriteria;
import org.opensaml.xml.security.criteria.UsageCriteria;
import org.opensaml.xml.validation.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ConsumerEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(ConsumerEndpoint.class);
    @Autowired
    @Qualifier(value="spKeyStoreLoader")
    private KeyStoreLoader keyStoreLoader;
    @Autowired
    @Qualifier(value="timeService")
    private TimeService timeService;
    @Autowired
    @Qualifier(value="idService")
    private IDService idService;
    private String singleSignOnServiceURL;
    private String assertionConsumerServiceURL;
    @Autowired
    @Qualifier(value="extractRedirectBindingAdapter")
    private ExtractBindingAdapter extractBindingAdapter;
    @Autowired
    private AppsSaml20DetailsService saml20DetailsService;
    @Autowired
    @Qualifier(value="issueInstantRule")
    private IssueInstantRule issueInstantRule;
    @Autowired
    @Qualifier(value="messageReplayRule")
    private MessageReplayRule messageReplayRule;
    EndpointGenerator endpointGenerator;
    AuthnRequestGenerator authnRequestGenerator;
    CredentialResolver credentialResolver;
    Credential signingCredential;
    SAML2ValidatorSuite validatorSuite = new SAML2ValidatorSuite();

    @RequestMapping(value={"/consumer/saml/v20/{spId}"})
    public ModelAndView consumer(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="spId") String spId) throws Exception {
        logger.debug("Attempting authentication.");
        this.initCredential(spId);
        Object messageContext = null;
        logger.debug("Message received from issuer: " + messageContext.getInboundMessageIssuer());
        if (!(messageContext.getInboundSAMLMessage() instanceof Response)) {
            logger.error("SAML Message was not a Response");
            throw new Exception();
        }
        List assertionList = ((Response)messageContext.getInboundSAMLMessage()).getAssertions();
        String credentials = this.extractBindingAdapter.extractSAMLMessage(request);
        Response samlResponse = (Response)messageContext.getInboundSAMLMessage();
        WebAuthenticationDetailsSource authenticationDetailsSource = new WebAuthenticationDetailsSource();
        try {
            this.validatorSuite.validate((XMLObject)samlResponse);
        }
        catch (ValidationException ve) {
            logger.warn("Response Message failed Validation", (Throwable)ve);
            throw new ServiceProviderAuthenticationException("Invalid SAML REsponse Message", ve);
        }
        this.checkResponseStatus(samlResponse);
        Assertion assertion = (Assertion)samlResponse.getAssertions().get(0);
        logger.debug("authenticationResponseIssuingEntityName {}", (Object)samlResponse.getIssuer().getValue());
        String username = assertion.getSubject().getNameID().getValue();
        logger.debug("assertion.getID() ", (Object)assertion.getID());
        logger.debug("assertion.getSubject().getNameID().getValue() ", (Object)username);
        logger.debug("assertion.getID() ", (Object)assertion.getAuthnStatements());
        WebContext.setAuthentication((String)username, (String)"SAML v2.0 Trust", (String)"", (String)"", (String)"success");
        ModelAndView mav = new ModelAndView();
        mav.addObject("username", (Object)username);
        mav.setViewName("redirect:/consumer/saml/v20/forward/webseal/eai");
        return mav;
    }

    public void afterPropertiesSet() throws Exception {
        this.authnRequestGenerator = new AuthnRequestGenerator(this.keyStoreLoader.getEntityName(), this.timeService, this.idService);
        this.endpointGenerator = new EndpointGenerator();
        CriteriaSet criteriaSet = new CriteriaSet();
        criteriaSet.add((Object)new EntityIDCriteria(this.keyStoreLoader.getEntityName()));
        criteriaSet.add((Object)new UsageCriteria(UsageType.SIGNING));
        try {
            this.signingCredential = (Credential)this.credentialResolver.resolveSingle((Object)criteriaSet);
        }
        catch (SecurityException e) {
            logger.error("\u8bc1\u4e66\u89e3\u6790\u51fa\u9519", (Throwable)e);
            throw new Exception(e);
        }
        Validate.notNull((Object)this.signingCredential);
    }

    private void initCredential(String spId) throws Exception {
        AppsSAML20Details saml20Details = (AppsSAML20Details)this.saml20DetailsService.get(spId);
        if (saml20Details == null) {
            logger.error("spid[" + spId + "] not exists");
            throw new Exception();
        }
        byte[] keyStoreBytes = saml20Details.getKeyStore();
        ByteArrayInputStream keyStoreStream = new ByteArrayInputStream(keyStoreBytes);
        try {
            KeyStore keyStore = KeyStore.getInstance(this.keyStoreLoader.getKeystoreType());
            keyStore.load(keyStoreStream, this.keyStoreLoader.getKeystorePassword().toCharArray());
            HashMap<String, String> passwords = new HashMap<String, String>();
            Enumeration<String> en = keyStore.aliases();
            while (en.hasMoreElements()) {
                String aliase = en.nextElement();
                if (!aliase.equalsIgnoreCase(this.keyStoreLoader.getEntityName())) continue;
                passwords.put(aliase, this.keyStoreLoader.getKeystorePassword());
            }
            AuthnResponseGenerator authnResponseGenerator = new AuthnResponseGenerator(this.keyStoreLoader.getEntityName(), this.timeService, this.idService);
            CriteriaSet criteriaSet = new CriteriaSet();
            criteriaSet.add((Object)new EntityIDCriteria(this.keyStoreLoader.getEntityName()));
            criteriaSet.add((Object)new UsageCriteria(UsageType.SIGNING));
            KeyStoreCredentialResolver credentialResolver = new KeyStoreCredentialResolver(keyStore, passwords);
            this.signingCredential = credentialResolver.resolveSingle(criteriaSet);
            Validate.notNull((Object)this.signingCredential);
            TrustResolver trustResolver = new TrustResolver(keyStore, this.keyStoreLoader.getEntityName(), this.keyStoreLoader.getKeystorePassword(), this.issueInstantRule, this.messageReplayRule, "POST");
            this.extractBindingAdapter.setSecurityPolicyResolver((SecurityPolicyResolver)trustResolver.getStaticSecurityPolicyResolver());
        }
        catch (Exception e) {
            logger.error("\u521d\u59cb\u5316sp\u8bc1\u4e66\u51fa\u9519");
            throw new Exception(e);
        }
    }

    private void checkResponseStatus(Response samlResponse) {
        if (!"urn:oasis:names:tc:SAML:2.0:status:Success".equals(StringUtils.trim((String)samlResponse.getStatus().getStatusCode().getValue()))) {
            StringBuilder extraInformation = this.extractExtraInformation(samlResponse);
            if (extraInformation.length() > 0) {
                logger.warn("Extra information extracted from authentication failure was {}", (Object)extraInformation.toString());
                throw new IdentityProviderAuthenticationException("Identity Provider has failed the authentication.", extraInformation.toString());
            }
            throw new IdentityProviderAuthenticationException("Identity Provider has failed the authentication.");
        }
        this.additionalValidationChecksOnSuccessfulResponse(samlResponse);
    }

    private void additionalValidationChecksOnSuccessfulResponse(Response samlResponse) {
        if (samlResponse.getAssertions().isEmpty()) {
            throw new ServiceProviderAuthenticationException("Successful Response did not contain any assertions");
        }
        if (((Assertion)samlResponse.getAssertions().get(0)).getAuthnStatements().isEmpty()) {
            throw new ServiceProviderAuthenticationException("Successful Response did not contain an assertions with an AuthnStatement");
        }
        if (((Assertion)samlResponse.getAssertions().get(0)).getAttributeStatements().isEmpty()) {
            throw new ServiceProviderAuthenticationException("Successful Response did not contain an assertions with an AttributeStatements");
        }
        if (samlResponse.getIssuer() == null) {
            throw new ServiceProviderAuthenticationException("Successful Response did not contain any Issuer");
        }
    }

    private StringBuilder extractExtraInformation(Response samlResponse) {
        StringBuilder extraInformation = new StringBuilder();
        if (samlResponse.getStatus().getStatusCode().getStatusCode() != null) {
            extraInformation.append(samlResponse.getStatus().getStatusCode().getStatusCode().getValue());
        }
        if (samlResponse.getStatus().getStatusMessage() != null) {
            if (extraInformation.length() > 0) {
                extraInformation.append("  -  ");
            }
            extraInformation.append(samlResponse.getStatus().getStatusMessage());
        }
        return extraInformation;
    }
}

