/*
 * Decompiled with CFR 0.152.
 */
package org.maxkey.authz.saml.common;

import java.security.KeyStore;
import java.util.HashMap;
import org.maxkey.authz.saml.common.SecurityPolicyDelegate;
import org.maxkey.authz.saml.common.SignatureSecurityPolicyRule;
import org.opensaml.common.binding.security.IssueInstantRule;
import org.opensaml.common.binding.security.MessageReplayRule;
import org.opensaml.security.SAMLSignatureProfileValidator;
import org.opensaml.ws.security.SecurityPolicy;
import org.opensaml.ws.security.SecurityPolicyRule;
import org.opensaml.ws.security.provider.StaticSecurityPolicyResolver;
import org.opensaml.xml.security.credential.CredentialResolver;
import org.opensaml.xml.security.credential.KeyStoreCredentialResolver;

public class TrustResolver {
    KeyStoreCredentialResolver keyStoreCredentialResolver;
    SignatureSecurityPolicyRule signatureSecurityPolicyRule;
    StaticSecurityPolicyResolver staticSecurityPolicyResolver;
    String binding;

    public TrustResolver() {
    }

    public KeyStoreCredentialResolver buildKeyStoreCredentialResolver(KeyStore trustKeyStore, String key, String password) {
        HashMap<String, String> passwords = new HashMap<String, String>();
        passwords.put(key, password);
        this.keyStoreCredentialResolver = new KeyStoreCredentialResolver(trustKeyStore, passwords);
        return this.keyStoreCredentialResolver;
    }

    public TrustResolver(KeyStore trustKeyStore, String issuing, String password) {
        this.buildKeyStoreCredentialResolver(trustKeyStore, issuing, password);
        this.initPolicyRule();
    }

    public TrustResolver(KeyStore trustKeyStore, String issuing, String password, IssueInstantRule issueInstantRule, MessageReplayRule messageReplayRule, String binding) {
        this.binding = binding;
        this.buildKeyStoreCredentialResolver(trustKeyStore, issuing, password);
        this.initPolicyRule();
        SecurityPolicyDelegate securityPolicyDelegate = new SecurityPolicyDelegate();
        if (binding.equalsIgnoreCase("post")) {
            securityPolicyDelegate.addSecurityPolicy(this.signatureSecurityPolicyRule);
        }
        securityPolicyDelegate.addSecurityPolicy((SecurityPolicyRule)issueInstantRule);
        securityPolicyDelegate.addSecurityPolicy((SecurityPolicyRule)messageReplayRule);
        this.staticSecurityPolicyResolver = new StaticSecurityPolicyResolver((SecurityPolicy)securityPolicyDelegate);
    }

    public void initPolicyRule() {
        this.signatureSecurityPolicyRule = new SignatureSecurityPolicyRule((CredentialResolver)this.keyStoreCredentialResolver, new SAMLSignatureProfileValidator());
        this.signatureSecurityPolicyRule.loadTrustEngine();
    }

    public void loadStaticSecurityPolicyResolver(IssueInstantRule issueInstantRule, MessageReplayRule messageReplayRule) {
        SecurityPolicyDelegate securityPolicyDelegate = new SecurityPolicyDelegate();
        if (this.binding.equalsIgnoreCase("post")) {
            securityPolicyDelegate.addSecurityPolicy(this.signatureSecurityPolicyRule);
        }
        securityPolicyDelegate.addSecurityPolicy((SecurityPolicyRule)issueInstantRule);
        securityPolicyDelegate.addSecurityPolicy((SecurityPolicyRule)messageReplayRule);
        this.staticSecurityPolicyResolver = new StaticSecurityPolicyResolver((SecurityPolicy)securityPolicyDelegate);
    }

    public KeyStoreCredentialResolver getKeyStoreCredentialResolver() {
        return this.keyStoreCredentialResolver;
    }

    public StaticSecurityPolicyResolver getStaticSecurityPolicyResolver() {
        return this.staticSecurityPolicyResolver;
    }
}

