/*
 * Decompiled with CFR 0.152.
 */
package com.connsec.oidc.jose;

import com.google.common.base.Strings;
import com.nimbusds.jose.JWSAlgorithm;
import javax.persistence.Basic;
import javax.persistence.Embeddable;
import javax.persistence.Transient;

@Embeddable
public class JWSAlgorithmEmbed {
    public static final JWSAlgorithmEmbed NONE = JWSAlgorithmEmbed.getForAlgorithmName("none");
    private JWSAlgorithm algorithm;

    public JWSAlgorithmEmbed() {
    }

    public JWSAlgorithmEmbed(JWSAlgorithm algorithm) {
        this.algorithm = algorithm;
    }

    public static JWSAlgorithmEmbed getForAlgorithmName(String algorithmName) {
        JWSAlgorithmEmbed ent = new JWSAlgorithmEmbed();
        ent.setAlgorithmName(algorithmName);
        if (ent.getAlgorithm() == null) {
            return null;
        }
        return ent;
    }

    @Basic
    public String getAlgorithmName() {
        if (this.algorithm != null) {
            return this.algorithm.getName();
        }
        return null;
    }

    public void setAlgorithmName(String algorithmName) {
        this.algorithm = !Strings.isNullOrEmpty((String)algorithmName) ? JWSAlgorithm.parse((String)algorithmName) : null;
    }

    @Transient
    public JWSAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(JWSAlgorithm algorithm) {
        this.algorithm = algorithm;
    }

    public String toString() {
        return "JWSAlgorithmEmbed [algorithm=" + this.algorithm + "]";
    }
}

