/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.provider;

import java.util.ArrayList;
import java.util.Map;
import org.apache.ibatis.jdbc.SQL;
import org.dromara.mybatis.jpa.entity.JpaEntity;
import org.dromara.mybatis.jpa.metadata.FieldColumnMapper;
import org.dromara.mybatis.jpa.metadata.MapperMetadata;
import org.dromara.mybatis.jpa.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindProvider<T extends JpaEntity> {
    private static final Logger logger = LoggerFactory.getLogger(FindProvider.class);

    public String findAll(Map<String, Object> parametersMap) {
        Class entityClass = (Class)parametersMap.get("entityClass");
        MapperMetadata.buildColumnList(entityClass);
        String tableName = MapperMetadata.getTableName(entityClass);
        if (MapperMetadata.sqlsMap.containsKey(String.valueOf(tableName) + "_FINDALL_SQL")) {
            return (String)MapperMetadata.sqlsMap.get(String.valueOf(tableName) + "_FINDALL_SQL");
        }
        SQL sql = MapperMetadata.buildSelect(entityClass);
        FieldColumnMapper logicColumnMapper = MapperMetadata.getLogicColumn(entityClass.getSimpleName());
        if (logicColumnMapper != null && logicColumnMapper.isLogicDelete()) {
            sql.WHERE(" %s = %s".formatted(logicColumnMapper.getColumnName(), logicColumnMapper.getColumnLogic().value()));
        }
        String findAllSql = sql.toString();
        logger.trace("Find All SQL \n{}", (Object)findAllSql);
        MapperMetadata.sqlsMap.put(String.valueOf(tableName) + "_FINDALL_SQL", findAllSql);
        return findAllSql;
    }

    public String find(Map<String, Object> parametersMap) throws Exception {
        Class entityClass = (Class)parametersMap.get("entityClass");
        Object[] args = (Object[])parametersMap.get("args");
        int[] argTypes = (int[])parametersMap.get("argTypes");
        String filterSql = parametersMap.get("filter").toString().trim();
        MapperMetadata.buildColumnList(entityClass);
        if (filterSql.toLowerCase().startsWith("where")) {
            filterSql = filterSql.substring(5);
        }
        if (args == null || args.length == 0) {
            filterSql = StringUtils.lineBreak2Blank(filterSql);
        } else {
            int countMatches = StringUtils.countMatches((CharSequence)filterSql, (CharSequence)"?");
            if (args.length < countMatches) {
                logger.error("args length {} < parameter placeholder {}", (Object)countMatches, (Object)args.length);
                throw new Exception("args length < parameter placeholder");
            }
            String[] filterSqls = filterSql.split("\\?");
            StringBuffer sqlBuffer = new StringBuffer("");
            int i = 0;
            while (i < args.length) {
                logger.trace("Find args[{}] {}", (Object)i, args[i]);
                if (argTypes[i] == 12 || argTypes[i] == -9 || argTypes[i] == 1 || argTypes[i] == -15 || argTypes[i] == -1 || argTypes[i] == -16) {
                    sqlBuffer.append(filterSqls[i]).append("'").append(args[i].toString().replaceAll("'", "")).append("'");
                } else {
                    sqlBuffer.append(filterSqls[i]).append(args[i]);
                }
                ++i;
            }
            filterSql = StringUtils.lineBreak2Blank(sqlBuffer.toString());
        }
        SQL sql = (SQL)MapperMetadata.buildSelect(entityClass).WHERE(filterSql);
        String findSql = sql.toString();
        logger.trace("Find SQL \n{}", (Object)findSql);
        return findSql;
    }

    public String findByIds(Map<String, Object> parametersMap) {
        Class parameterEntityClass = (Class)parametersMap.get("entityClass");
        MapperMetadata.buildColumnList(parameterEntityClass);
        ArrayList parameterIds = (ArrayList)parametersMap.get("idList");
        StringBuffer keyValue = new StringBuffer();
        for (String value : parameterIds) {
            if (value.trim().length() <= 0) continue;
            keyValue.append(",'").append(value).append("'");
            logger.trace("find by id {}", (Object)value);
        }
        String idsValues = keyValue.substring(1).replaceAll(";", "");
        String partitionKeyValue = (String)parametersMap.get("partitionKey");
        FieldColumnMapper partitionKeyColumnMapper = MapperMetadata.getPartitionKey(parameterEntityClass.getSimpleName());
        FieldColumnMapper idFieldColumnMapper = MapperMetadata.getIdColumn(parameterEntityClass.getSimpleName());
        SQL sql = MapperMetadata.buildSelect(parameterEntityClass);
        if (partitionKeyColumnMapper != null && partitionKeyValue != null) {
            sql.WHERE("%s = #{%s} and %s  in ( %s )".formatted(partitionKeyColumnMapper.getColumnName(), partitionKeyValue, idFieldColumnMapper.getColumnName(), idsValues));
        } else {
            sql.WHERE(" %s in ( %s )".formatted(idFieldColumnMapper.getColumnName(), idsValues));
        }
        String findByIdsSql = sql.toString();
        logger.trace("Find by ids SQL \n{}", (Object)findByIdsSql);
        return findByIdsSql;
    }
}

