/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mybatis.jpa.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Properties;
import org.slf4j.LoggerFactory;

public class MacAddress {
    public static String os;

    static {
        Properties prop = System.getProperties();
        os = prop.getProperty("os.name");
        LoggerFactory.getLogger(MacAddress.class).info("OS : " + os);
    }

    public static String getAllHostMacAddress() {
        String hostIpAddress = "";
        try {
            Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
            InetAddress inetAddress = null;
            while (netInterfaces.hasMoreElements()) {
                NetworkInterface ni = netInterfaces.nextElement();
                if (!ni.getInetAddresses().hasMoreElements() || (inetAddress = ni.getInetAddresses().nextElement()).isLoopbackAddress()) continue;
                hostIpAddress = String.valueOf(hostIpAddress) + MacAddress.getMac(inetAddress) + ",";
                LoggerFactory.getLogger(MacAddress.class).info("host MAC : " + MacAddress.getMac(inetAddress));
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return hostIpAddress;
    }

    public static String getMac(InetAddress ia) throws SocketException {
        byte[] mac = NetworkInterface.getByInetAddress(ia).getHardwareAddress();
        StringBuffer sb = new StringBuffer("");
        int i = 0;
        while (i < mac.length) {
            int temp;
            String str;
            if (i != 0) {
                if (os.startsWith("win") || os.startsWith("Win")) {
                    sb.append("-");
                } else {
                    sb.append(":");
                }
            }
            if ((str = Integer.toHexString(temp = mac[i] & 0xFF)).length() == 1) {
                sb.append("0" + str);
            } else {
                sb.append(str);
            }
            ++i;
        }
        return sb.toString().toUpperCase();
    }
}

