/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mybatis.jpa.util;

import java.util.ArrayList;
import java.util.List;

public class StringUtils {
    public static boolean isNumeric(String val) {
        char[] chars = val.toCharArray();
        if (chars.length == 0) {
            return false;
        }
        int i = chars.length - 1;
        while (i >= 0) {
            char c = chars[i];
            if (c < '0' || c > '9') {
                return false;
            }
            --i;
        }
        return true;
    }

    public static long lastNumber(String val) {
        long num = 0L;
        char[] chars = val.toCharArray();
        if (chars.length == 0) {
            throw new NumberFormatException(val);
        }
        long j = 1L;
        int i = chars.length - 1;
        while (i >= 0) {
            char c = chars[i];
            if (c < '0' || c > '9') break;
            int bit = c - 48;
            num += (long)bit * j;
            --i;
            j *= 10L;
        }
        return num;
    }

    public static boolean isBlank(String str) {
        return str == null || str.matches("\\s*");
    }

    public static boolean isNotBlank(String val) {
        return !StringUtils.isBlank(val);
    }

    public static List<String> string2List(String string, String split) {
        String[] strs = new String[]{};
        if (string != null && !string.equals("")) {
            strs = string.split(split);
        }
        ArrayList<String> resultList = new ArrayList<String>(0);
        int i = 0;
        while (i < strs.length) {
            if (strs[i] != null && !strs[i].equals("")) {
                resultList.add(strs[i]);
            }
            ++i;
        }
        resultList.trimToSize();
        return resultList;
    }

    public static String list2String(List<String> list, String split) {
        String string = "";
        if (list == null) {
            return string;
        }
        int i = 0;
        while (i < list.size()) {
            if (list.get(i) != null && !list.get(i).equals("")) {
                string = String.valueOf(string) + list.get(i) + split;
            }
            ++i;
        }
        if (string.length() > 0) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }
}

