/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.metadata;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.Transient;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ibatis.jdbc.SQL;
import org.dromara.mybatis.jpa.annotations.ColumnDefault;
import org.dromara.mybatis.jpa.annotations.ColumnLogic;
import org.dromara.mybatis.jpa.annotations.PartitionKey;
import org.dromara.mybatis.jpa.entity.JpaEntity;
import org.dromara.mybatis.jpa.id.IdentifierGeneratorFactory;
import org.dromara.mybatis.jpa.metadata.FieldColumnMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapperMetadata<T extends JpaEntity> {
    private static final Logger logger = LoggerFactory.getLogger(MapperMetadata.class);
    public static final String ENTITY_CLASS = "entityClass";
    public static final String ENTITY = "entity";
    public static final String PAGE = "page";
    public static final String CONDITION = "condition";
    public static final String QUERY_FILTER = "filter";
    public static final String QUERY_ARGS = "args";
    public static final String QUERY_ARGTYPES = "argTypes";
    public static final String PARAMETER_PARTITION_KEY = "partitionKey";
    public static final String PARAMETER_ID_LIST = "idList";
    public static final String PARAMETER_ID = "id";
    public static int TABLE_COLUMN_CASE = CASE_TYPE.LOWERCASE;
    public static boolean TABLE_COLUMN_ESCAPE = false;
    public static String TABLE_COLUMN_ESCAPE_CHAR = "`";
    public static String PARTITION_COLUMN = "inst_id";
    public static ConcurrentMap<String, List<FieldColumnMapper>> fieldsMap = new ConcurrentHashMap<String, List<FieldColumnMapper>>();
    public static ConcurrentMap<String, String> sqlsMap = new ConcurrentHashMap<String, String>();
    public static ConcurrentMap<String, String> tableNameMap = new ConcurrentHashMap<String, String>();
    public static IdentifierGeneratorFactory identifierGeneratorFactory = new IdentifierGeneratorFactory();

    public static String getTableName(Class<?> entityClass) {
        String entityClassName = entityClass.getSimpleName();
        logger.debug("entity Class Name {}", (Object)entityClassName);
        if (tableNameMap.containsKey(entityClassName)) {
            return (String)tableNameMap.get(entityClassName);
        }
        String tableName = null;
        String schema = null;
        String catalog = null;
        Entity entity = entityClass.getAnnotation(Entity.class);
        logger.trace("entity {}", (Object)entity);
        Table table = entityClass.getAnnotation(Table.class);
        logger.trace("table {}", (Object)table);
        if (entity != null) {
            if (entity.name() != null && !entity.name().equals("")) {
                tableName = entity.name();
            }
            if (table != null) {
                if (table.name() != null && !table.name().equals("")) {
                    tableName = table.name();
                }
                if (table.schema() != null && !table.schema().equals("")) {
                    schema = table.schema();
                    logger.trace("schema {}", (Object)schema);
                }
                if (table.catalog() != null && !table.catalog().equals("")) {
                    catalog = table.catalog();
                    logger.trace("catalog {}", (Object)catalog);
                }
            }
            if (tableName == null) {
                tableName = entityClassName;
            }
            if (schema != null) {
                tableName = String.valueOf(schema) + "." + tableName;
            }
            if (catalog != null) {
                tableName = String.valueOf(catalog) + "." + tableName;
            }
        }
        tableName = MapperMetadata.tableColumnCaseConverter(tableName);
        tableName = TABLE_COLUMN_ESCAPE ? String.valueOf(TABLE_COLUMN_ESCAPE_CHAR) + tableName + TABLE_COLUMN_ESCAPE_CHAR : tableName;
        tableNameMap.put(entityClassName, tableName);
        logger.trace("Table Name {}", (Object)tableName);
        return tableName;
    }

    public static FieldColumnMapper getIdColumn(String classSimpleName) {
        List listFields = (List)fieldsMap.get(classSimpleName);
        FieldColumnMapper idFieldColumnMapper = null;
        int i = 0;
        while (i < listFields.size()) {
            if (((FieldColumnMapper)listFields.get(i)).isIdColumn()) {
                idFieldColumnMapper = (FieldColumnMapper)listFields.get(i);
                break;
            }
            ++i;
        }
        return idFieldColumnMapper;
    }

    public static FieldColumnMapper getLogicColumn(String classSimpleName) {
        List listFields = (List)fieldsMap.get(classSimpleName);
        FieldColumnMapper logicColumnMapper = null;
        int i = 0;
        while (i < listFields.size()) {
            if (((FieldColumnMapper)listFields.get(i)).isLogicDelete()) {
                logicColumnMapper = (FieldColumnMapper)listFields.get(i);
                break;
            }
            ++i;
        }
        return logicColumnMapper;
    }

    public static FieldColumnMapper getPartitionKey(String classSimpleName) {
        List listFields = (List)fieldsMap.get(classSimpleName);
        FieldColumnMapper partitionKeyColumnMapper = null;
        for (FieldColumnMapper column : listFields) {
            if (column.getPartitionKey() == null) continue;
            partitionKeyColumnMapper = column;
            break;
        }
        return partitionKeyColumnMapper;
    }

    public static String selectColumnMapper(Class<?> entityClass) {
        StringBuffer selectColumn = new StringBuffer("sel_tmp_table.* ");
        int columnCount = 0;
        for (FieldColumnMapper fieldColumnMapper : (List)fieldsMap.get(entityClass.getSimpleName())) {
            ++columnCount;
            if (!fieldColumnMapper.getColumnName().equalsIgnoreCase(fieldColumnMapper.getFieldName())) {
                selectColumn.append(",").append(fieldColumnMapper.getColumnName()).append(" ").append(fieldColumnMapper.getFieldName());
            }
            logger.trace("Column {} , ColumnName : {} , FieldName : {}", new Object[]{columnCount, fieldColumnMapper.getColumnName(), fieldColumnMapper.getFieldName()});
        }
        return selectColumn.toString();
    }

    public static SQL buildSelect(Class<?> entityClass) {
        MapperMetadata.buildColumnList(entityClass);
        return (SQL)((SQL)new SQL().SELECT(MapperMetadata.selectColumnMapper(entityClass))).FROM(String.valueOf(MapperMetadata.getTableName(entityClass)) + " sel_tmp_table ");
    }

    public static void buildColumnList(Class<?> entityClass) {
        if (fieldsMap.containsKey(entityClass.getSimpleName())) {
            return;
        }
        logger.trace("entityClass {}", entityClass);
        Field[] fields = entityClass.getDeclaredFields();
        ArrayList<FieldColumnMapper> fieldColumnMapperList = new ArrayList<FieldColumnMapper>(fields.length);
        Field[] fieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (!field.isAnnotationPresent(Transient.class) && field.isAnnotationPresent(Column.class)) {
                FieldColumnMapper fieldColumnMapper = new FieldColumnMapper();
                fieldColumnMapper.setFieldName(field.getName());
                fieldColumnMapper.setFieldType(field.getType().getSimpleName());
                String columnName = "";
                Column columnAnnotation = field.getAnnotation(Column.class);
                fieldColumnMapper.setColumnAnnotation(columnAnnotation);
                columnName = columnAnnotation.name() != null && !columnAnnotation.name().equals("") ? columnAnnotation.name() : field.getName();
                columnName = MapperMetadata.tableColumnCaseConverter(columnName);
                columnName = TABLE_COLUMN_ESCAPE ? String.valueOf(TABLE_COLUMN_ESCAPE_CHAR) + columnName + TABLE_COLUMN_ESCAPE_CHAR : columnName;
                fieldColumnMapper.setColumnName(columnName);
                if (field.isAnnotationPresent(Id.class)) {
                    fieldColumnMapper.setIdColumn(true);
                }
                if (field.isAnnotationPresent(GeneratedValue.class)) {
                    GeneratedValue generatedValue = field.getAnnotation(GeneratedValue.class);
                    fieldColumnMapper.setGeneratedValue(generatedValue);
                    fieldColumnMapper.setGenerated(true);
                }
                if (field.isAnnotationPresent(Temporal.class)) {
                    Temporal temporalAnnotation = field.getAnnotation(Temporal.class);
                    fieldColumnMapper.setTemporalAnnotation(temporalAnnotation);
                }
                if (field.isAnnotationPresent(ColumnDefault.class)) {
                    ColumnDefault columnDefault = field.getAnnotation(ColumnDefault.class);
                    fieldColumnMapper.setColumnDefault(columnDefault);
                }
                if (field.isAnnotationPresent(PartitionKey.class)) {
                    PartitionKey partitionKey = field.getAnnotation(PartitionKey.class);
                    fieldColumnMapper.setPartitionKey(partitionKey);
                }
                if (field.isAnnotationPresent(ColumnLogic.class)) {
                    ColumnLogic columnLogic = field.getAnnotation(ColumnLogic.class);
                    fieldColumnMapper.setColumnLogic(columnLogic);
                    fieldColumnMapper.setLogicDelete(true);
                }
                logger.trace("FieldColumnMapper : {}", (Object)fieldColumnMapper);
                fieldColumnMapperList.add(fieldColumnMapper);
            }
            ++n2;
        }
        fieldsMap.put(entityClass.getSimpleName(), fieldColumnMapperList);
        logger.trace("fieldsMap : {}", fieldsMap);
    }

    public static String tableColumnCaseConverter(String name) {
        if (TABLE_COLUMN_CASE != CASE_TYPE.NORMAL) {
            if (TABLE_COLUMN_CASE == CASE_TYPE.LOWERCASE) {
                name = name.toLowerCase();
            } else if (TABLE_COLUMN_CASE == CASE_TYPE.UPPERCASE) {
                name = name.toUpperCase();
            }
        }
        return name;
    }

    public static class CASE_TYPE {
        public static int NORMAL = 0;
        public static int LOWERCASE = 1;
        public static int UPPERCASE = 2;
    }

    public static class SQL_TYPE {
        public static final String GET_SQL = "_GET_SQL";
        public static final String FINDALL_SQL = "_FINDALL_SQL";
        public static final String REMOVE_SQL = "_REMOVE_SQL";
        public static final String BATCHDELETE_SQL = "_BATCHDELETE_SQL";
        public static final String LOGICDELETE_SQL = "_LOGICDELETE_SQL";
    }
}

