/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mybatis.jpa.persistence;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.mybatis.jpa.id.IdentifierGeneratorFactory;
import org.apache.mybatis.jpa.persistence.FieldColumnMapper;
import org.apache.mybatis.jpa.persistence.JpaBaseEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapperMetadata<T extends JpaBaseEntity> {
    private static final Logger _logger = LoggerFactory.getLogger(MapperMetadata.class);
    public static String ENTITY_CLASS = "entityClass";
    public static int TABLE_COLUMN_CASE = CASE_TYPE.LOWERCASE;
    public static boolean TABLE_COLUMN_ESCAPE = false;
    public static String TABLE_COLUMN_ESCAPE_CHAR = "`";
    public static transient ConcurrentMap<String, List<FieldColumnMapper>> fieldsMap = new ConcurrentHashMap<String, List<FieldColumnMapper>>();
    public static transient ConcurrentMap<String, String> sqlsMap = new ConcurrentHashMap<String, String>();
    public static IdentifierGeneratorFactory identifierGeneratorFactory = new IdentifierGeneratorFactory();

    public static String getTableName(Class<?> entityClass) {
        String tableName = null;
        String schema = null;
        String catalog = null;
        Entity entity = entityClass.getAnnotation(Entity.class);
        _logger.trace("entity " + entity);
        Table table = entityClass.getAnnotation(Table.class);
        _logger.trace("table " + table);
        if (entity != null) {
            if (entity.name() != null && !entity.name().equals("")) {
                tableName = entity.name();
            }
            if (table != null) {
                if (table.name() != null && !table.name().equals("")) {
                    tableName = table.name();
                }
                if (table.schema() != null && !table.schema().equals("")) {
                    schema = table.schema();
                    _logger.trace("schema " + schema);
                }
                if (table.catalog() != null && !table.catalog().equals("")) {
                    catalog = table.catalog();
                    _logger.trace("catalog " + catalog);
                }
            }
            if (tableName == null) {
                tableName = entityClass.getClass().getSimpleName();
            }
            if (schema != null) {
                tableName = String.valueOf(schema) + "." + tableName;
            }
            if (catalog != null) {
                tableName = String.valueOf(catalog) + "." + tableName;
            }
        }
        tableName = MapperMetadata.tableColumnCaseConverter(tableName);
        tableName = TABLE_COLUMN_ESCAPE ? String.valueOf(TABLE_COLUMN_ESCAPE_CHAR) + tableName + TABLE_COLUMN_ESCAPE_CHAR : tableName;
        _logger.trace("Table Name " + tableName);
        return tableName;
    }

    public static FieldColumnMapper getIdColumn(String classSimpleName) {
        List listFields = (List)fieldsMap.get(classSimpleName);
        FieldColumnMapper idFieldColumnMapper = null;
        int i = 0;
        while (i < listFields.size()) {
            if (((FieldColumnMapper)listFields.get(i)).isIdColumn()) {
                idFieldColumnMapper = (FieldColumnMapper)listFields.get(i);
                break;
            }
            ++i;
        }
        return idFieldColumnMapper;
    }

    public static void buildColumnList(Class<?> entityClass) {
        if (fieldsMap.containsKey(entityClass.getSimpleName())) {
            return;
        }
        _logger.trace("entityClass " + entityClass);
        Field[] fields = entityClass.getDeclaredFields();
        ArrayList<FieldColumnMapper> fieldColumnMapperList = new ArrayList<FieldColumnMapper>(fields.length);
        Field[] fieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (!field.isAnnotationPresent(Transient.class) && field.isAnnotationPresent(Column.class)) {
                FieldColumnMapper fieldColumnMapper = new FieldColumnMapper();
                fieldColumnMapper.setFieldName(field.getName());
                fieldColumnMapper.setFieldType(field.getType().getSimpleName());
                String columnName = "";
                Column columnAnnotation = field.getAnnotation(Column.class);
                columnName = columnAnnotation.name() != null && !columnAnnotation.name().equals("") ? columnAnnotation.name() : field.getName();
                columnName = MapperMetadata.tableColumnCaseConverter(columnName);
                columnName = TABLE_COLUMN_ESCAPE ? String.valueOf(TABLE_COLUMN_ESCAPE_CHAR) + columnName + TABLE_COLUMN_ESCAPE_CHAR : columnName;
                fieldColumnMapper.setColumnName(columnName);
                if (field.isAnnotationPresent(Id.class)) {
                    fieldColumnMapper.setIdColumn(true);
                }
                if (field.isAnnotationPresent(GeneratedValue.class)) {
                    GeneratedValue generatedValue = field.getAnnotation(GeneratedValue.class);
                    fieldColumnMapper.setGeneratedValue(generatedValue);
                }
                _logger.trace("FieldColumnMapper : " + fieldColumnMapper);
                fieldColumnMapperList.add(fieldColumnMapper);
            }
            ++n2;
        }
        fieldsMap.put(entityClass.getSimpleName(), fieldColumnMapperList);
        _logger.trace("fieldsMap : " + fieldsMap);
    }

    public static String tableColumnCaseConverter(String name) {
        if (TABLE_COLUMN_CASE != CASE_TYPE.NORMAL) {
            if (TABLE_COLUMN_CASE == CASE_TYPE.LOWERCASE) {
                name = name.toLowerCase();
            } else if (TABLE_COLUMN_CASE == CASE_TYPE.UPPERCASE) {
                name = name.toUpperCase();
            }
        }
        return name;
    }

    public static class CASE_TYPE {
        public static int NORMAL = 0;
        public static int LOWERCASE = 1;
        public static int UPPERCASE = 2;
    }

    public static class SQL_TYPE {
        public static String GET_SQL = "_GET_SQL";
        public static String FINDALL_SQL = "_FINDALL_SQL";
        public static String REMOVE_SQL = "_REMOVE_SQL";
    }
}

