/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.util;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import net.jcip.annotations.NotThreadSafe;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.util.LazyList;
import org.opensaml.xml.util.LazyMap;
import org.opensaml.xml.util.ListView;
import org.opensaml.xml.util.XMLObjectChildrenList;

@NotThreadSafe
public class IndexedXMLObjectChildrenList<ElementType extends XMLObject>
extends XMLObjectChildrenList<ElementType> {
    private Map<QName, List<ElementType>> objectIndex = new LazyMap<QName, List<ElementType>>();

    public IndexedXMLObjectChildrenList(XMLObject parent) {
        super(parent);
    }

    public IndexedXMLObjectChildrenList(XMLObject parent, Collection<ElementType> col) {
        super(parent);
        this.addAll(col);
    }

    @Override
    public void add(int index, ElementType element) {
        super.add(index, element);
        this.indexElement(element);
    }

    @Override
    public void clear() {
        super.clear();
        this.objectIndex.clear();
    }

    public List<ElementType> get(QName typeOrName) {
        this.checkAndCreateIndex(typeOrName);
        return this.objectIndex.get(typeOrName);
    }

    protected void checkAndCreateIndex(QName index) {
        if (!this.objectIndex.containsKey(index)) {
            this.objectIndex.put(index, new LazyList());
        }
    }

    protected void indexElement(ElementType element) {
        if (element == null) {
            return;
        }
        QName type = element.getSchemaType();
        if (type != null) {
            this.indexElement(type, element);
        }
        this.indexElement(element.getElementQName(), element);
    }

    protected void indexElement(QName index, ElementType element) {
        List<ElementType> objects = this.get(index);
        objects.add(element);
    }

    @Override
    public boolean remove(ElementType element) {
        boolean elementRemoved = false;
        elementRemoved = super.remove(element);
        if (elementRemoved) {
            this.removeElementFromIndex(element);
        }
        return elementRemoved;
    }

    @Override
    public ElementType remove(int index) {
        Object returnValue = super.remove(index);
        this.removeElementFromIndex(returnValue);
        return (ElementType)returnValue;
    }

    protected void removeElementFromIndex(ElementType element) {
        if (element == null) {
            return;
        }
        QName type = element.getSchemaType();
        if (type != null) {
            this.removeElementFromIndex(type, element);
        }
        this.removeElementFromIndex(element.getElementQName(), element);
    }

    protected void removeElementFromIndex(QName index, ElementType element) {
        List<ElementType> objects = this.get(index);
        objects.remove(element);
    }

    @Override
    public ElementType set(int index, ElementType element) {
        ElementType returnValue = super.set(index, element);
        this.removeElementFromIndex(returnValue);
        this.indexElement(element);
        return returnValue;
    }

    public List<? extends ElementType> subList(QName index) {
        this.checkAndCreateIndex(index);
        return new ListView(this, index);
    }
}

