/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.security.credential.criteria;

import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.credential.criteria.EvaluableCredentialCriteria;
import org.opensaml.xml.security.criteria.KeyNameCriteria;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluableKeyNameCredentialCriteria
implements EvaluableCredentialCriteria {
    private final Logger log = LoggerFactory.getLogger(EvaluableKeyNameCredentialCriteria.class);
    private String keyName;

    public EvaluableKeyNameCredentialCriteria(KeyNameCriteria criteria) {
        if (criteria == null) {
            throw new NullPointerException("Criteria instance may not be null");
        }
        this.keyName = criteria.getKeyName();
    }

    public EvaluableKeyNameCredentialCriteria(String newKeyName) {
        if (DatatypeHelper.isEmpty(newKeyName)) {
            throw new IllegalArgumentException("Key name may not be null");
        }
        this.keyName = newKeyName;
    }

    @Override
    public Boolean evaluate(Credential target) {
        if (target == null) {
            this.log.error("Credential target was null");
            return null;
        }
        if (target.getKeyNames().isEmpty()) {
            this.log.info("Could not evaluate criteria, credential contained no key names");
            return null;
        }
        Boolean result = target.getKeyNames().contains(this.keyName);
        return result;
    }
}

