/*
 * Decompiled with CFR 0.152.
 */
package org.maxkey.authz.oidc.idtoken;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jwt.JWT;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdTokenHashUtils {
    private static Logger logger = LoggerFactory.getLogger(IdTokenHashUtils.class);

    public static Base64URL getCodeHash(JWSAlgorithm signingAlg, String code) {
        return IdTokenHashUtils.getHash(signingAlg, code.getBytes());
    }

    public static Base64URL getAccessTokenHash(JWSAlgorithm signingAlg, JWT jwt) {
        byte[] tokenBytes = jwt.serialize().getBytes();
        return IdTokenHashUtils.getHash(signingAlg, tokenBytes);
    }

    public static Base64URL getHash(JWSAlgorithm signingAlg, byte[] bytes) {
        String hashAlg = null;
        if (signingAlg.equals((Object)JWSAlgorithm.HS256) || signingAlg.equals((Object)JWSAlgorithm.ES256) || signingAlg.equals((Object)JWSAlgorithm.RS256)) {
            hashAlg = "SHA-256";
        } else if (signingAlg.equals((Object)JWSAlgorithm.ES384) || signingAlg.equals((Object)JWSAlgorithm.HS384) || signingAlg.equals((Object)JWSAlgorithm.RS384)) {
            hashAlg = "SHA-384";
        } else if (signingAlg.equals((Object)JWSAlgorithm.ES512) || signingAlg.equals((Object)JWSAlgorithm.HS512) || signingAlg.equals((Object)JWSAlgorithm.RS512)) {
            hashAlg = "SHA-512";
        }
        if (hashAlg != null) {
            try {
                MessageDigest hasher = MessageDigest.getInstance(hashAlg);
                hasher.reset();
                hasher.update(bytes);
                byte[] hashBytes = hasher.digest();
                byte[] hashBytesLeftHalf = Arrays.copyOf(hashBytes, hashBytes.length / 2);
                Base64URL encodedHash = Base64URL.encode((byte[])hashBytesLeftHalf);
                return encodedHash;
            }
            catch (NoSuchAlgorithmException e) {
                logger.error("No such algorithm error: ", (Throwable)e);
            }
        }
        return null;
    }
}

