/*
 * Decompiled with CFR 0.152.
 */
package org.maxkey.authz.oauth2.provider.refresh;

import org.maxkey.authz.oauth2.common.OAuth2AccessToken;
import org.maxkey.authz.oauth2.provider.ClientDetailsService;
import org.maxkey.authz.oauth2.provider.OAuth2RequestFactory;
import org.maxkey.authz.oauth2.provider.TokenRequest;
import org.maxkey.authz.oauth2.provider.token.AbstractTokenGranter;
import org.maxkey.authz.oauth2.provider.token.AuthorizationServerTokenServices;
import org.maxkey.domain.apps.oauth2.provider.ClientDetails;

public class RefreshTokenGranter
extends AbstractTokenGranter {
    private static final String GRANT_TYPE = "refresh_token";

    public RefreshTokenGranter(AuthorizationServerTokenServices tokenServices, ClientDetailsService clientDetailsService, OAuth2RequestFactory requestFactory) {
        super(tokenServices, clientDetailsService, requestFactory, GRANT_TYPE);
    }

    @Override
    protected OAuth2AccessToken getAccessToken(ClientDetails client, TokenRequest tokenRequest) {
        String refreshToken = (String)tokenRequest.getRequestParameters().get(GRANT_TYPE);
        return this.getTokenServices().refreshAccessToken(refreshToken, tokenRequest);
    }
}

