/*
 * Decompiled with CFR 0.152.
 */
package org.maxkey.authz.oauth2.provider.endpoint;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maxkey.authn.BasicAuthentication;
import org.maxkey.authz.oauth2.common.util.OAuth2Utils;
import org.maxkey.authz.oauth2.provider.AuthorizationRequest;
import org.maxkey.authz.oauth2.provider.OAuth2Authentication;
import org.maxkey.authz.oauth2.provider.OAuth2Request;
import org.maxkey.authz.oauth2.provider.OAuth2RequestFactory;
import org.maxkey.web.WebContext;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.HttpRequestMethodNotSupportedException;

@WebFilter(filterName="TokenEndpointAuthenticationFilter", urlPatterns={"/oauth/v20/token/*"})
public class TokenEndpointAuthenticationFilter
implements Filter {
    private static final Log logger = LogFactory.getLog(TokenEndpointAuthenticationFilter.class);
    private AuthenticationDetailsSource<HttpServletRequest, ?> authenticationDetailsSource = new WebAuthenticationDetailsSource();
    boolean allowOnlyPost;
    private AuthenticationManager authenticationManager;
    private OAuth2RequestFactory oAuth2RequestFactory;

    public TokenEndpointAuthenticationFilter() {
    }

    public TokenEndpointAuthenticationFilter(AuthenticationManager authenticationManager, OAuth2RequestFactory oAuth2RequestFactory) {
        this.authenticationManager = authenticationManager;
        this.oAuth2RequestFactory = oAuth2RequestFactory;
    }

    public void setAuthenticationDetailsSource(AuthenticationDetailsSource<HttpServletRequest, ?> authenticationDetailsSource) {
        this.authenticationDetailsSource = authenticationDetailsSource;
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        logger.debug((Object)"Authentication TokenEndpoint ");
        if (this.authenticationManager == null) {
            this.authenticationManager = (AuthenticationManager)WebContext.getBean((String)"oauth20ClientAuthenticationManager");
        }
        if (this.oAuth2RequestFactory == null) {
            this.oAuth2RequestFactory = (OAuth2RequestFactory)WebContext.getBean((String)"oAuth2RequestFactory");
        }
        boolean debug = logger.isDebugEnabled();
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        try {
            String grantType = request.getParameter("grant_type");
            if (grantType != null && grantType.equals("password")) {
                this.usernamepassword(request, response);
            } else {
                Authentication authentication = this.ClientCredentials(request, response);
                BasicAuthentication auth = new BasicAuthentication();
                auth.setJ_username(((User)authentication.getPrincipal()).getUsername());
                auth.setAuthenticated(true);
                UsernamePasswordAuthenticationToken simpleUserAuthentication = new UsernamePasswordAuthenticationToken((Object)auth, authentication.getCredentials(), authentication.getAuthorities());
                WebContext.setAuthentication((Authentication)simpleUserAuthentication);
            }
        }
        catch (AuthenticationException failed) {
            SecurityContextHolder.clearContext();
            if (debug) {
                logger.debug((Object)("Authentication request for failed: " + (Object)((Object)failed)));
            }
            this.onUnsuccessfulAuthentication(request, response, failed);
            return;
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void usernamepassword(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        logger.debug((Object)"Authentication TokenEndpoint ");
        try {
            Authentication credentials = this.extractCredentials(request);
            if (credentials != null) {
                logger.debug((Object)("Authentication credentials found for '" + credentials.getName() + "'"));
                Authentication authResult = this.authenticationManager.authenticate(credentials);
                logger.debug((Object)("Authentication success: " + authResult.getName()));
                Authentication clientAuth = SecurityContextHolder.getContext().getAuthentication();
                if (clientAuth == null) {
                    throw new BadCredentialsException("No client authentication found. Remember to put a filter upstream of the TokenEndpointAuthenticationFilter.");
                }
                Map<String, String> map = this.getSingleValueMap(request);
                map.put("client_id", clientAuth.getName());
                AuthorizationRequest authorizationRequest = this.oAuth2RequestFactory.createAuthorizationRequest(map);
                authorizationRequest.setScope(this.getScope(request));
                if (clientAuth.isAuthenticated()) {
                    authorizationRequest.setApproved(true);
                }
                OAuth2Request storedOAuth2Request = this.oAuth2RequestFactory.createOAuth2Request(authorizationRequest);
                WebContext.setAuthentication((Authentication)new OAuth2Authentication(storedOAuth2Request, authResult));
                this.onSuccessfulAuthentication(request, response, authResult);
            }
        }
        catch (AuthenticationException failed) {
            SecurityContextHolder.clearContext();
            logger.debug((Object)("Authentication request for failed: " + (Object)((Object)failed)));
            this.onUnsuccessfulAuthentication(request, response, failed);
            return;
        }
    }

    public Authentication ClientCredentials(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException, IOException, ServletException {
        if (this.allowOnlyPost && !"POST".equalsIgnoreCase(request.getMethod())) {
            throw new HttpRequestMethodNotSupportedException(request.getMethod(), new String[]{"POST"});
        }
        String clientId = request.getParameter("client_id");
        String clientSecret = request.getParameter("client_secret");
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null && authentication.isAuthenticated()) {
            return authentication;
        }
        if (clientId == null) {
            throw new BadCredentialsException("No client credentials presented");
        }
        if (clientSecret == null) {
            clientSecret = "";
        }
        clientId = clientId.trim();
        UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken((Object)clientId, (Object)clientSecret);
        return this.authenticationManager.authenticate((Authentication)authRequest);
    }

    private Map<String, String> getSingleValueMap(HttpServletRequest request) {
        HashMap<String, String> map = new HashMap<String, String>();
        Map parameters = request.getParameterMap();
        Iterator iterator = parameters.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            String[] values = (String[])parameters.get(key = (String)iterator.next());
            map.put(key, values != null && values.length > 0 ? values[0] : null);
        }
        return map;
    }

    protected void onSuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, Authentication authResult) throws IOException {
    }

    protected void onUnsuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationException failed) throws IOException {
    }

    protected Authentication extractCredentials(HttpServletRequest request) {
        String grantType = request.getParameter("grant_type");
        if (grantType != null && grantType.equals("password")) {
            UsernamePasswordAuthenticationToken result = new UsernamePasswordAuthenticationToken((Object)request.getParameter("username"), (Object)request.getParameter("password"));
            result.setDetails(this.authenticationDetailsSource.buildDetails((Object)request));
            return result;
        }
        return null;
    }

    private Set<String> getScope(HttpServletRequest request) {
        return OAuth2Utils.parseParameterList(request.getParameter("scope"));
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    protected static class ClientCredentialsRequestMatcher
    implements RequestMatcher {
        private String path;

        public ClientCredentialsRequestMatcher(String path) {
            this.path = path;
        }

        public boolean matches(HttpServletRequest request) {
            String clientId;
            String uri = request.getRequestURI();
            int pathParamIndex = uri.indexOf(59);
            if (pathParamIndex > 0) {
                uri = uri.substring(0, pathParamIndex);
            }
            if ((clientId = request.getParameter("client_id")) == null) {
                return false;
            }
            if ("".equals(request.getContextPath())) {
                return uri.endsWith(this.path);
            }
            return uri.endsWith(request.getContextPath() + this.path);
        }
    }
}

