/*
 * Decompiled with CFR 0.152.
 */
package org.maxkey.authz.oauth2.provider.code;

import java.io.Serializable;
import org.maxkey.authz.oauth2.provider.OAuth2Authentication;
import org.maxkey.authz.oauth2.provider.code.RandomValueAuthorizationCodeServices;
import org.maxkey.persistence.redis.RedisConnection;
import org.maxkey.persistence.redis.RedisConnectionFactory;

public class RedisAuthorizationCodeServices
extends RandomValueAuthorizationCodeServices {
    RedisConnectionFactory connectionFactory;
    public static String PREFIX = "MAXKEY_REDIS_OAUTH_V20_CODE_";
    protected int codeValiditySeconds = 600;

    public RedisAuthorizationCodeServices(RedisConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public void setConnectionFactory(RedisConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    @Override
    protected void store(String code, OAuth2Authentication authentication) {
        RedisConnection conn = this.connectionFactory.getConnection();
        conn.setexObject(PREFIX + code, this.codeValiditySeconds, (Serializable)((Object)authentication));
        conn.close();
    }

    @Override
    public OAuth2Authentication remove(String code) {
        RedisConnection conn = this.connectionFactory.getConnection();
        OAuth2Authentication auth = (OAuth2Authentication)((Object)conn.getObject(PREFIX + code));
        conn.delete(PREFIX + code);
        return auth;
    }
}

