/*
 * Decompiled with CFR 0.152.
 */
package org.maxkey.authz.oauth2.provider.code;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.maxkey.authz.oauth2.common.exceptions.InvalidClientException;
import org.maxkey.authz.oauth2.common.exceptions.InvalidGrantException;
import org.maxkey.authz.oauth2.common.exceptions.InvalidRequestException;
import org.maxkey.authz.oauth2.common.exceptions.RedirectMismatchException;
import org.maxkey.authz.oauth2.provider.ClientDetailsService;
import org.maxkey.authz.oauth2.provider.OAuth2Authentication;
import org.maxkey.authz.oauth2.provider.OAuth2Request;
import org.maxkey.authz.oauth2.provider.OAuth2RequestFactory;
import org.maxkey.authz.oauth2.provider.TokenRequest;
import org.maxkey.authz.oauth2.provider.code.AuthorizationCodeServices;
import org.maxkey.authz.oauth2.provider.token.AbstractTokenGranter;
import org.maxkey.authz.oauth2.provider.token.AuthorizationServerTokenServices;
import org.maxkey.domain.apps.oauth2.provider.ClientDetails;
import org.springframework.security.core.Authentication;

public class AuthorizationCodeTokenGranter
extends AbstractTokenGranter {
    private static final String GRANT_TYPE = "authorization_code";
    private final AuthorizationCodeServices authorizationCodeServices;

    public AuthorizationCodeTokenGranter(AuthorizationServerTokenServices tokenServices, AuthorizationCodeServices authorizationCodeServices, ClientDetailsService clientDetailsService, OAuth2RequestFactory requestFactory) {
        super(tokenServices, clientDetailsService, requestFactory, GRANT_TYPE);
        this.authorizationCodeServices = authorizationCodeServices;
    }

    @Override
    protected OAuth2Authentication getOAuth2Authentication(ClientDetails client, TokenRequest tokenRequest) {
        Map parameters = tokenRequest.getRequestParameters();
        String authorizationCode = (String)parameters.get("code");
        String redirectUri = (String)parameters.get("redirect_uri");
        if (authorizationCode == null) {
            throw new InvalidRequestException("An authorization code must be supplied.");
        }
        OAuth2Authentication storedAuth = this.authorizationCodeServices.consumeAuthorizationCode(authorizationCode);
        if (storedAuth == null) {
            throw new InvalidGrantException("Invalid authorization code: " + authorizationCode);
        }
        OAuth2Request pendingOAuth2Request = storedAuth.getOAuth2Request();
        String redirectUriApprovalParameter = (String)pendingOAuth2Request.getRequestParameters().get("redirect_uri");
        String pendingClientId = pendingOAuth2Request.getClientId();
        String clientId = tokenRequest.getClientId();
        Set redirectUris = client.getRegisteredRedirectUri();
        boolean redirectMismatch = false;
        for (String storedRedirectUri : redirectUris) {
            if (!redirectUri.startsWith(storedRedirectUri)) continue;
            redirectMismatch = true;
        }
        if (!(redirectUri == null && redirectUriApprovalParameter == null || redirectMismatch)) {
            this.logger.info((Object)("storedAuth redirectUri " + pendingOAuth2Request.getRedirectUri()));
            this.logger.info((Object)("redirectUri " + redirectUri));
            this.logger.info((Object)("storedRedirectUri " + redirectUris));
            throw new RedirectMismatchException("Redirect URI mismatch.");
        }
        if (clientId != null && !clientId.equals(pendingClientId)) {
            throw new InvalidClientException("Client ID mismatch");
        }
        HashMap<String, String> combinedParameters = new HashMap<String, String>(pendingOAuth2Request.getRequestParameters());
        combinedParameters.putAll(parameters);
        OAuth2Request finalStoredOAuth2Request = pendingOAuth2Request.createOAuth2Request(combinedParameters);
        Authentication userAuth = storedAuth.getUserAuthentication();
        return new OAuth2Authentication(finalStoredOAuth2Request, userAuth);
    }
}

