/*
 * Decompiled with CFR 0.152.
 */
package org.maxkey.authz.oauth2.provider.approval;

import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import org.maxkey.authz.oauth2.common.OAuth2AccessToken;
import org.maxkey.authz.oauth2.provider.OAuth2Authentication;
import org.maxkey.authz.oauth2.provider.approval.Approval;
import org.maxkey.authz.oauth2.provider.approval.ApprovalStore;
import org.maxkey.authz.oauth2.provider.token.TokenStore;

public class TokenApprovalStore
implements ApprovalStore {
    private TokenStore store;

    public void setTokenStore(TokenStore store) {
        this.store = store;
    }

    @Override
    public boolean addApprovals(Collection<Approval> approvals) {
        return true;
    }

    @Override
    public boolean revokeApprovals(Collection<Approval> approvals) {
        boolean success = true;
        for (Approval approval : approvals) {
            Collection<OAuth2AccessToken> tokens = this.store.findTokensByClientIdAndUserName(approval.getClientId(), approval.getUserId());
            for (OAuth2AccessToken token : tokens) {
                OAuth2Authentication authentication = this.store.readAuthentication(token);
                if (authentication == null || !approval.getClientId().equals(authentication.getOAuth2Request().getClientId())) continue;
                this.store.removeAccessToken(token);
            }
        }
        return success;
    }

    @Override
    public Collection<Approval> getApprovals(String userId, String clientId) {
        HashSet<Approval> result = new HashSet<Approval>();
        Collection<OAuth2AccessToken> tokens = this.store.findTokensByClientIdAndUserName(clientId, userId);
        for (OAuth2AccessToken token : tokens) {
            OAuth2Authentication authentication = this.store.readAuthentication(token);
            if (authentication == null) continue;
            Date expiresAt = token.getExpiration();
            for (String scope : token.getScope()) {
                result.add(new Approval(userId, clientId, scope, expiresAt, Approval.ApprovalStatus.APPROVED));
            }
        }
        return result;
    }
}

