/*
 * Decompiled with CFR 0.152.
 */
package org.maxkey.authz.oauth2.provider.approval;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.maxkey.authz.oauth2.provider.approval.Approval;
import org.maxkey.authz.oauth2.provider.approval.ApprovalStore;

public class InMemoryApprovalStore
implements ApprovalStore {
    private ConcurrentMap<Key, Collection<Approval>> map = new ConcurrentHashMap<Key, Collection<Approval>>();

    @Override
    public boolean addApprovals(Collection<Approval> approvals) {
        for (Approval approval : approvals) {
            Collection<Approval> collection = this.getApprovals(approval);
            collection.add(approval);
        }
        return true;
    }

    @Override
    public boolean revokeApprovals(Collection<Approval> approvals) {
        boolean success = true;
        for (Approval approval : approvals) {
            Collection<Approval> collection = this.getApprovals(approval);
            boolean removed = collection.remove(approval);
            if (removed) continue;
            success = false;
        }
        return success;
    }

    private Collection<Approval> getApprovals(Approval approval) {
        Key key = new Key(approval.getUserId(), approval.getClientId());
        if (!this.map.containsKey(key)) {
            this.map.putIfAbsent(key, new HashSet());
        }
        return (Collection)this.map.get(key);
    }

    @Override
    public Collection<Approval> getApprovals(String userId, String clientId) {
        Approval approval = new Approval();
        approval.setUserId(userId);
        approval.setClientId(clientId);
        return Collections.unmodifiableCollection(this.getApprovals(approval));
    }

    public void clear() {
        this.map.clear();
    }

    private static class Key {
        String userId;
        String clientId;

        public Key(String userId, String clientId) {
            this.userId = userId;
            this.clientId = clientId;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.clientId == null ? 0 : this.clientId.hashCode());
            result = 31 * result + (this.userId == null ? 0 : this.userId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (this.clientId == null ? other.clientId != null : !this.clientId.equals(other.clientId)) {
                return false;
            }
            return !(this.userId == null ? other.userId != null : !this.userId.equals(other.userId));
        }
    }
}

