/*
 * Decompiled with CFR 0.152.
 */
package org.maxkey.authz.oauth2.provider;

import java.util.ArrayList;
import java.util.List;
import org.maxkey.authz.oauth2.common.OAuth2AccessToken;
import org.maxkey.authz.oauth2.provider.TokenGranter;
import org.maxkey.authz.oauth2.provider.TokenRequest;

public class CompositeTokenGranter
implements TokenGranter {
    private final List<TokenGranter> tokenGranters;

    public CompositeTokenGranter(List<TokenGranter> tokenGranters) {
        this.tokenGranters = new ArrayList<TokenGranter>(tokenGranters);
    }

    @Override
    public OAuth2AccessToken grant(String grantType, TokenRequest tokenRequest) {
        for (TokenGranter granter : this.tokenGranters) {
            OAuth2AccessToken grant = granter.grant(grantType, tokenRequest);
            if (grant == null) continue;
            return grant;
        }
        return null;
    }
}

