/*
 * Decompiled with CFR 0.152.
 */
package org.maxkey.authz.oauth2.jwt;

import org.maxkey.authz.oauth2.jwt.Jwt;
import org.maxkey.authz.oauth2.jwt.JwtHeader;
import org.maxkey.authz.oauth2.jwt.JwtHelper;
import org.maxkey.authz.oauth2.jwt.codec.Codecs;
import org.maxkey.authz.oauth2.jwt.crypto.sign.SignatureVerifier;

class JwtImpl
implements Jwt {
    private final JwtHeader header;
    private final byte[] content;
    private final byte[] crypto;
    private String claims;

    JwtImpl(JwtHeader header, byte[] content, byte[] crypto) {
        this.header = header;
        this.content = content;
        this.crypto = crypto;
        this.claims = Codecs.utf8Decode(content);
    }

    @Override
    public void verifySignature(SignatureVerifier verifier) {
        verifier.verify(this.signingInput(), this.crypto);
    }

    private byte[] signingInput() {
        return Codecs.concat(Codecs.b64UrlEncode(this.header.bytes()), JwtHelper.PERIOD, Codecs.b64UrlEncode(this.content));
    }

    @Override
    public byte[] bytes() {
        return Codecs.concat(Codecs.b64UrlEncode(this.header.bytes()), JwtHelper.PERIOD, Codecs.b64UrlEncode(this.content), JwtHelper.PERIOD, Codecs.b64UrlEncode(this.crypto));
    }

    @Override
    public String getClaims() {
        return Codecs.utf8Decode(this.content);
    }

    @Override
    public String getEncoded() {
        return Codecs.utf8Decode(this.bytes());
    }

    public String toString() {
        return this.header + " " + this.claims + " [" + this.crypto.length + " crypto bytes]";
    }
}

