/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.annotation.support;

import java.lang.annotation.Annotation;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.messaging.Message;
import org.springframework.messaging.core.MessagePostProcessor;
import org.springframework.messaging.handler.annotation.SendTo;
import org.springframework.messaging.handler.invocation.HandlerMethodReturnValueHandler;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.messaging.simp.SimpMessageSendingOperations;
import org.springframework.messaging.simp.annotation.SendToUser;
import org.springframework.messaging.simp.annotation.support.MissingSessionUserException;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class SendToMethodReturnValueHandler
implements HandlerMethodReturnValueHandler {
    private final SimpMessageSendingOperations messagingTemplate;
    private final boolean annotationRequired;
    private String defaultDestinationPrefix = "/topic";
    private String defaultUserDestinationPrefix = "/queue";

    public SendToMethodReturnValueHandler(SimpMessageSendingOperations messagingTemplate, boolean annotationRequired) {
        Assert.notNull((Object)messagingTemplate, (String)"messagingTemplate must not be null");
        this.messagingTemplate = messagingTemplate;
        this.annotationRequired = annotationRequired;
    }

    public void setDefaultDestinationPrefix(String defaultDestinationPrefix) {
        this.defaultDestinationPrefix = defaultDestinationPrefix;
    }

    public String getDefaultDestinationPrefix() {
        return this.defaultDestinationPrefix;
    }

    public void setDefaultUserDestinationPrefix(String prefix) {
        this.defaultUserDestinationPrefix = prefix;
    }

    public String getDefaultUserDestinationPrefix() {
        return this.defaultUserDestinationPrefix;
    }

    @Override
    public boolean supportsReturnType(MethodParameter returnType) {
        if (returnType.getMethodAnnotation(SendTo.class) != null || returnType.getMethodAnnotation(SendToUser.class) != null) {
            return true;
        }
        return !this.annotationRequired;
    }

    @Override
    public void handleReturnValue(Object returnValue, MethodParameter returnType, Message<?> inputMessage) throws Exception {
        String[] destinations;
        if (returnValue == null) {
            return;
        }
        SimpMessageHeaderAccessor inputHeaders = SimpMessageHeaderAccessor.wrap(inputMessage);
        String sessionId = inputHeaders.getSessionId();
        SessionHeaderPostProcessor postProcessor = new SessionHeaderPostProcessor(sessionId);
        SendToUser sendToUser = (SendToUser)returnType.getMethodAnnotation(SendToUser.class);
        if (sendToUser != null) {
            String[] destinations2;
            if (inputHeaders.getUser() == null) {
                throw new MissingSessionUserException(inputMessage);
            }
            String user = inputHeaders.getUser().getName();
            for (String destination : destinations2 = this.getTargetDestinations(sendToUser, inputHeaders, this.defaultUserDestinationPrefix)) {
                this.messagingTemplate.convertAndSendToUser(user, destination, returnValue, postProcessor);
            }
            return;
        }
        SendTo sendTo = (SendTo)returnType.getMethodAnnotation(SendTo.class);
        for (String destination : destinations = this.getTargetDestinations(sendTo, inputHeaders, this.defaultDestinationPrefix)) {
            this.messagingTemplate.convertAndSend(destination, returnValue, postProcessor);
        }
    }

    protected String[] getTargetDestinations(Annotation annot, SimpMessageHeaderAccessor inputHeaders, String defaultPrefix) {
        Object[] value;
        if (annot != null && !ObjectUtils.isEmpty((Object[])(value = (String[])AnnotationUtils.getValue((Annotation)annot)))) {
            return value;
        }
        return new String[]{defaultPrefix + inputHeaders.getDestination()};
    }

    public String toString() {
        return "SendToMethodReturnValueHandler [annotationRequired=" + this.annotationRequired + "]";
    }

    private final class SessionHeaderPostProcessor
    implements MessagePostProcessor {
        private final String sessionId;

        public SessionHeaderPostProcessor(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public Message<?> postProcessMessage(Message<?> message) {
            SimpMessageHeaderAccessor headers = SimpMessageHeaderAccessor.wrap(message);
            headers.setSessionId(this.sessionId);
            return MessageBuilder.withPayload(message.getPayload()).setHeaders(headers).build();
        }
    }
}

