/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mybatis.jpa.persistence.provider;

import java.util.List;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import org.apache.ibatis.jdbc.SQL;
import org.apache.mybatis.jpa.persistence.FieldColumnMapper;
import org.apache.mybatis.jpa.persistence.JpaBaseEntity;
import org.apache.mybatis.jpa.persistence.MapperMetadata;
import org.apache.mybatis.jpa.util.BeanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlProviderInsert<T extends JpaBaseEntity> {
    private static final Logger _logger = LoggerFactory.getLogger(SqlProviderInsert.class);

    public String insert(T entity) {
        MapperMetadata.buildColumnList(entity.getClass());
        List listFields = (List)MapperMetadata.fieldsMap.get(entity.getClass().getSimpleName());
        SQL sql = (SQL)new SQL().INSERT_INTO(MapperMetadata.getTableName(entity.getClass()));
        for (int i = 0; i < listFields.size(); ++i) {
            FieldColumnMapper fieldColumnMapper = (FieldColumnMapper)listFields.get(i);
            if ((fieldColumnMapper.getFieldType().equalsIgnoreCase("String") || fieldColumnMapper.getFieldType().startsWith("byte")) && BeanUtil.getValue(entity, fieldColumnMapper.getFieldName()) == null && fieldColumnMapper.getGeneratedValue() == null) {
                _logger.trace("skip  field value is null ");
                continue;
            }
            if (fieldColumnMapper.getGeneratedValue() != null && (BeanUtil.get(entity, fieldColumnMapper.getFieldName()) == null || BeanUtil.get(entity, fieldColumnMapper.getFieldName()) == "")) {
                GeneratedValue generatedValue = ((FieldColumnMapper)listFields.get(i)).getGeneratedValue();
                if (generatedValue.strategy() == GenerationType.AUTO) {
                    if (!MapperMetadata.identifierGeneratorFactory.getGeneratorStrategyMap().containsKey(generatedValue.generator().toLowerCase())) continue;
                    BeanUtil.set(entity, fieldColumnMapper.getFieldName(), MapperMetadata.identifierGeneratorFactory.generate(generatedValue.generator().toLowerCase()));
                    sql.VALUES(fieldColumnMapper.getColumnName(), "#{" + fieldColumnMapper.getFieldName() + "}");
                    continue;
                }
                if (generatedValue.strategy() == GenerationType.SEQUENCE) {
                    sql.VALUES(fieldColumnMapper.getColumnName(), generatedValue.generator() + ".nextval");
                    continue;
                }
                if (generatedValue.strategy() != GenerationType.IDENTITY && generatedValue.strategy() != GenerationType.TABLE) continue;
            }
            sql.VALUES(fieldColumnMapper.getColumnName(), "#{" + fieldColumnMapper.getFieldName() + "}");
        }
        _logger.trace("Insert SQL : \n" + sql);
        return sql.toString();
    }
}

