/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mybatis.jpa.dialect;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.mybatis.jpa.dialect.Dialect;
import org.apache.mybatis.jpa.persistence.JpaPagination;

public class PostgreSQLDialect
extends Dialect {
    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public String getLimitString(String sql, JpaPagination pagination) {
        if (pagination.getPageSize() > 0 && pagination.getStartRow() > 0) {
            return sql + " limit " + pagination.getPageSize() + " offset  " + pagination.getStartRow();
        }
        if (pagination.getPageSize() > 0) {
            return sql + " limit " + pagination.getPageSize();
        }
        return sql + " limit 1000";
    }

    @Override
    public String getPreparedStatementLimitString(String sql, JpaPagination pagination) {
        if (pagination.getPageSize() > 0 && pagination.getStartRow() > 0) {
            return sql + " limit ? offset ?";
        }
        if (pagination.getPageSize() > 0) {
            return sql + " limit  ? ";
        }
        return sql + " limit ?";
    }

    @Override
    public void setLimitParamters(PreparedStatement preparedStatement, int parameterSize, JpaPagination pagination) {
        try {
            if (pagination.getPageSize() > 0 && pagination.getStartRow() > 0) {
                preparedStatement.setInt(++parameterSize, pagination.getPageSize());
                preparedStatement.setInt(++parameterSize, pagination.getPageSize());
            } else if (pagination.getPageSize() > 0) {
                preparedStatement.setInt(++parameterSize, pagination.getPageSize());
            } else {
                preparedStatement.setInt(++parameterSize, 1000);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String toString() {
        return "PostgreSQLDialect [" + PostgreSQLDialect.class + "]";
    }
}

