/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacAddress {
    private static final Logger logger = LoggerFactory.getLogger(MacAddress.class);
    public static final String OS_NAME;

    public static String getAllHostMacAddress() {
        StringBuilder hostIpAddress = new StringBuilder();
        try {
            Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
            InetAddress inetAddress = null;
            while (netInterfaces.hasMoreElements()) {
                NetworkInterface ni = netInterfaces.nextElement();
                if (!ni.getInetAddresses().hasMoreElements() || (inetAddress = ni.getInetAddresses().nextElement()).isLoopbackAddress()) continue;
                hostIpAddress.append(MacAddress.getMac(inetAddress)).append(",");
                logger.info("host MAC : {}", (Object)MacAddress.getMac(inetAddress));
            }
        }
        catch (SocketException e) {
            logger.error("Socket Exception", (Throwable)e);
        }
        return hostIpAddress.toString();
    }

    public static String getMac(InetAddress ia) throws SocketException {
        byte[] mac = NetworkInterface.getByInetAddress(ia).getHardwareAddress();
        StringBuilder sb = new StringBuilder("");
        for (int i = 0; i < mac.length; ++i) {
            int temp;
            String str;
            if (i != 0) {
                if (OS_NAME.startsWith("win") || OS_NAME.startsWith("Win")) {
                    sb.append("-");
                } else {
                    sb.append(":");
                }
            }
            if ((str = Integer.toHexString(temp = mac[i] & 0xFF)).length() == 1) {
                sb.append("0" + str);
                continue;
            }
            sb.append(str);
        }
        return sb.toString().toUpperCase();
    }

    static {
        Properties prop = System.getProperties();
        OS_NAME = prop.getProperty("os.name");
        logger.info("OS : {}", (Object)OS_NAME);
    }
}

