/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.provider.base;

import java.util.Map;
import org.apache.ibatis.jdbc.SQL;
import org.dromara.mybatis.jpa.entity.JpaEntity;
import org.dromara.mybatis.jpa.metadata.ColumnMapper;
import org.dromara.mybatis.jpa.metadata.ColumnMetadata;
import org.dromara.mybatis.jpa.metadata.TableMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetProvider<T extends JpaEntity> {
    static final Logger logger = LoggerFactory.getLogger(GetProvider.class);

    public String get(Map<String, Object> parametersMap) {
        ColumnMapper logicColumnMapper;
        Class entityClass = (Class)parametersMap.get("entityClass");
        ColumnMetadata.buildColumnMapper(entityClass);
        String partitionKeyValue = (String)parametersMap.get("partitionKey");
        ColumnMapper partitionKeyColumnMapper = ColumnMetadata.getPartitionKey(entityClass);
        ColumnMapper idFieldColumnMapper = ColumnMetadata.getIdColumn(entityClass);
        SQL sql = TableMetadata.buildSelect(entityClass);
        sql.WHERE(" %s = #{%s}".formatted(idFieldColumnMapper.getColumn(), idFieldColumnMapper.getField()));
        if (partitionKeyColumnMapper != null && partitionKeyValue != null) {
            sql.WHERE(" %s = #{%s} ".formatted(partitionKeyColumnMapper.getColumn(), partitionKeyValue));
        }
        if ((logicColumnMapper = ColumnMetadata.getLogicColumn(entityClass)) != null && logicColumnMapper.isLogicDelete()) {
            sql.WHERE(" %s = '%s'".formatted(logicColumnMapper.getColumn(), logicColumnMapper.getSoftDelete().value()));
        }
        String getSql = sql.toString();
        logger.trace("Get SQL \n{}", (Object)getSql);
        return getSql;
    }
}

