/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.metadata;

import jakarta.persistence.Column;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.Temporal;
import jakarta.persistence.Transient;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.dromara.mybatis.jpa.annotations.ColumnDefault;
import org.dromara.mybatis.jpa.annotations.Encrypted;
import org.dromara.mybatis.jpa.annotations.PartitionKey;
import org.dromara.mybatis.jpa.annotations.SoftDelete;
import org.dromara.mybatis.jpa.metadata.ColumnMapper;
import org.dromara.mybatis.jpa.metadata.MapperMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnMetadata {
    private static final Logger logger = LoggerFactory.getLogger(ColumnMetadata.class);
    static ConcurrentMap<String, List<ColumnMapper>> fieldsMap = new ConcurrentHashMap<String, List<ColumnMapper>>();
    static ConcurrentMap<String, ColumnMapper> logicColumnMap = new ConcurrentHashMap<String, ColumnMapper>();
    static ConcurrentMap<String, ColumnMapper> idColumnMap = new ConcurrentHashMap<String, ColumnMapper>();
    static ConcurrentMap<String, ColumnMapper> partitionKeyMap = new ConcurrentHashMap<String, ColumnMapper>();

    public static ColumnMapper getIdColumn(Class<?> entityClass) {
        return (ColumnMapper)idColumnMap.get(entityClass.getName());
    }

    public static ColumnMapper getLogicColumn(Class<?> entityClass) {
        return (ColumnMapper)logicColumnMap.get(entityClass.getName());
    }

    public static ColumnMapper getPartitionKey(Class<?> entityClass) {
        return (ColumnMapper)partitionKeyMap.get(entityClass.getName());
    }

    public static String selectColumnMapper(Class<?> entityClass) {
        StringBuilder selectColumn = new StringBuilder(" tmp_t.* ");
        int columnCount = 0;
        for (ColumnMapper fieldColumnMapper : (List)fieldsMap.get(entityClass.getName())) {
            ++columnCount;
            if (!fieldColumnMapper.getColumn().equalsIgnoreCase(fieldColumnMapper.getField())) {
                selectColumn.append(",").append(fieldColumnMapper.getColumn()).append(" ").append(fieldColumnMapper.getField());
            }
            if (!logger.isTraceEnabled()) continue;
            logger.trace("Column {} , ColumnName : {} , FieldName : {}", new Object[]{String.format("%-3s", columnCount), String.format("%-30s", fieldColumnMapper.getColumn()), fieldColumnMapper.getField()});
        }
        return selectColumn.toString();
    }

    public static List<ColumnMapper> buildColumnMapper(Class<?> entityClass) {
        String entityClassName = entityClass.getName();
        if (!fieldsMap.containsKey(entityClassName)) {
            logger.trace("entityClass {}", entityClass);
            Field[] fields = entityClass.getDeclaredFields();
            ArrayList<ColumnMapper> fieldColumnMapperList = new ArrayList<ColumnMapper>(fields.length);
            for (Field field : fields) {
                if (field.isAnnotationPresent(Transient.class) || !field.isAnnotationPresent(Column.class)) continue;
                String columnName = "";
                Column columnAnnotation = field.getAnnotation(Column.class);
                columnName = columnAnnotation.name() != null && !columnAnnotation.name().equals("") ? columnAnnotation.name() : field.getName();
                columnName = MapperMetadata.tableOrColumnCaseConverter(columnName);
                columnName = MapperMetadata.tableOrColumnEscape(columnName);
                ColumnMapper fieldColumnMapper = new ColumnMapper(field, field.getName(), field.getType().getSimpleName(), columnName);
                fieldColumnMapper.setColumnAnnotation(columnAnnotation);
                if (field.isAnnotationPresent(Id.class)) {
                    fieldColumnMapper.setIdColumn(true);
                    idColumnMap.put(entityClassName, fieldColumnMapper);
                }
                if (field.isAnnotationPresent(GeneratedValue.class)) {
                    GeneratedValue generatedValue = field.getAnnotation(GeneratedValue.class);
                    fieldColumnMapper.setGeneratedValue(generatedValue);
                    fieldColumnMapper.setGenerated(true);
                }
                if (field.isAnnotationPresent(Temporal.class)) {
                    Temporal temporalAnnotation = field.getAnnotation(Temporal.class);
                    fieldColumnMapper.setTemporalAnnotation(temporalAnnotation);
                }
                if (field.isAnnotationPresent(ColumnDefault.class)) {
                    ColumnDefault columnDefault = field.getAnnotation(ColumnDefault.class);
                    fieldColumnMapper.setColumnDefault(columnDefault);
                }
                if (field.isAnnotationPresent(PartitionKey.class)) {
                    PartitionKey partitionKey = field.getAnnotation(PartitionKey.class);
                    fieldColumnMapper.setPartitionKey(partitionKey);
                    partitionKeyMap.put(entityClassName, fieldColumnMapper);
                }
                if (field.isAnnotationPresent(SoftDelete.class)) {
                    SoftDelete columnLogic = field.getAnnotation(SoftDelete.class);
                    fieldColumnMapper.setSoftDelete(columnLogic);
                    fieldColumnMapper.setLogicDelete(true);
                    logicColumnMap.put(entityClassName, fieldColumnMapper);
                }
                if (field.isAnnotationPresent(Encrypted.class)) {
                    Encrypted columnEncrypted = field.getAnnotation(Encrypted.class);
                    fieldColumnMapper.setEncrypted(true);
                    fieldColumnMapper.setEncryptedAnnotation(columnEncrypted);
                }
                logger.trace("FieldColumnMapper : {}", (Object)fieldColumnMapper);
                fieldColumnMapperList.add(fieldColumnMapper);
            }
            fieldsMap.put(entityClassName, fieldColumnMapperList);
            logger.trace("fieldsMap : {}", fieldsMap);
        }
        return (List)fieldsMap.get(entityClassName);
    }
}

