/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.id;

import java.util.concurrent.ConcurrentHashMap;
import org.dromara.mybatis.jpa.id.IdentifierGenerator;
import org.dromara.mybatis.jpa.id.SerialGenerator;
import org.dromara.mybatis.jpa.id.SnowFlakeIdGenerator;
import org.dromara.mybatis.jpa.id.UUIDGenerator;
import org.dromara.mybatis.jpa.id.UUIDHexGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdentifierGeneratorFactory {
    private static final Logger logger = LoggerFactory.getLogger(IdentifierGeneratorFactory.class);
    public static ConcurrentHashMap<String, IdentifierGenerator> identifierGeneratorMap = new ConcurrentHashMap();

    public IdentifierGeneratorFactory() {
        this.register("uuid", new UUIDGenerator());
        this.register("uuid.hex", new UUIDHexGenerator());
        this.register("serial", new SerialGenerator());
        this.register("snowflakeid", new SnowFlakeIdGenerator());
        this.register("default", new SnowFlakeIdGenerator(null));
    }

    public IdentifierGeneratorFactory(long datacenterId, long machineId) {
        this.register("uuid", new UUIDGenerator());
        this.register("uuid.hex", new UUIDHexGenerator());
        this.register("serial", new SerialGenerator());
        SerialGenerator.STATIC_NODE_NUMBER = "" + datacenterId + machineId;
        this.register("snowflakeid", new SnowFlakeIdGenerator(datacenterId, machineId));
    }

    public static ConcurrentHashMap<String, IdentifierGenerator> getIdentifierGeneratorMap() {
        return identifierGeneratorMap;
    }

    public static void setIdentifierGeneratorMap(ConcurrentHashMap<String, IdentifierGenerator> identifierGeneratorMap) {
        IdentifierGeneratorFactory.identifierGeneratorMap = identifierGeneratorMap;
    }

    public void register(String strategy, IdentifierGenerator generator) {
        if (identifierGeneratorMap.containsKey(strategy = strategy.toLowerCase())) {
            return;
        }
        identifierGeneratorMap.put(strategy, generator);
        logger.debug("Registering IdentifierGenerator strategy [{}] -> [{}]", (Object)strategy, (Object)generator.getClass().getName());
    }

    public static boolean exists(String strategy) {
        return identifierGeneratorMap.containsKey(strategy.toLowerCase());
    }

    public static String generate(String strategy) {
        strategy = strategy.toLowerCase();
        return identifierGeneratorMap.get(strategy).generate(strategy);
    }
}

