/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.user;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.SmartLifecycle;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.messaging.core.MessageSendingOperations;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.messaging.simp.user.UserDestinationResolver;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class UserDestinationMessageHandler
implements MessageHandler,
SmartLifecycle {
    private static final Log logger = LogFactory.getLog(UserDestinationMessageHandler.class);
    private final SubscribableChannel clientInboundChannel;
    private final MessageChannel clientOutboundChannel;
    private final SubscribableChannel brokerChannel;
    private final MessageSendingOperations<String> brokerMessagingTemplate;
    private final UserDestinationResolver userDestinationResolver;
    private Object lifecycleMonitor = new Object();
    private volatile boolean running = false;

    public UserDestinationMessageHandler(SubscribableChannel clientInChannel, MessageChannel clientOutChannel, SubscribableChannel brokerChannel, UserDestinationResolver userDestinationResolver) {
        Assert.notNull((Object)clientInChannel, (String)"'clientInChannel' must not be null");
        Assert.notNull((Object)clientOutChannel, (String)"'clientOutChannel' must not be null");
        Assert.notNull((Object)brokerChannel, (String)"'brokerChannel' must not be null");
        Assert.notNull((Object)userDestinationResolver, (String)"DestinationResolver must not be null");
        this.clientInboundChannel = clientInChannel;
        this.clientOutboundChannel = clientOutChannel;
        this.brokerChannel = brokerChannel;
        this.brokerMessagingTemplate = new SimpMessagingTemplate(brokerChannel);
        this.userDestinationResolver = userDestinationResolver;
    }

    public UserDestinationResolver getUserDestinationResolver() {
        return this.userDestinationResolver;
    }

    public MessageSendingOperations<String> getBrokerMessagingTemplate() {
        return this.brokerMessagingTemplate;
    }

    public boolean isAutoStartup() {
        return true;
    }

    public int getPhase() {
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isRunning() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            return this.running;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.clientInboundChannel.subscribe(this);
            this.brokerChannel.subscribe(this);
            this.running = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.running = false;
            this.clientInboundChannel.unsubscribe(this);
            this.brokerChannel.unsubscribe(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop(Runnable callback) {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.stop();
            callback.run();
        }
    }

    @Override
    public void handleMessage(Message<?> message) throws MessagingException {
        Set<String> destinations = this.userDestinationResolver.resolveDestination(message);
        if (CollectionUtils.isEmpty(destinations)) {
            return;
        }
        for (String targetDestination : destinations) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Sending message to resolved destination=" + targetDestination));
            }
            this.brokerMessagingTemplate.send(targetDestination, message);
        }
    }
}

