/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.handler.annotation.support;

import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.ConversionService;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandlingException;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.messaging.handler.annotation.support.AbstractNamedValueMethodArgumentResolver;

public class HeaderMethodArgumentResolver
extends AbstractNamedValueMethodArgumentResolver {
    public HeaderMethodArgumentResolver(ConversionService cs, ConfigurableBeanFactory beanFactory) {
        super(cs, beanFactory);
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(Header.class);
    }

    @Override
    protected AbstractNamedValueMethodArgumentResolver.NamedValueInfo createNamedValueInfo(MethodParameter parameter) {
        Header annotation = (Header)parameter.getParameterAnnotation(Header.class);
        return new HeaderNamedValueInfo(annotation);
    }

    @Override
    protected Object resolveArgumentInternal(MethodParameter parameter, Message<?> message, String name) throws Exception {
        return message.getHeaders().get(name);
    }

    @Override
    protected void handleMissingValue(String headerName, MethodParameter parameter, Message<?> message) {
        throw new MessageHandlingException(message, "Missing header '" + headerName + "' for method parameter type [" + parameter.getParameterType() + "]");
    }

    private static class HeaderNamedValueInfo
    extends AbstractNamedValueMethodArgumentResolver.NamedValueInfo {
        private HeaderNamedValueInfo(Header annotation) {
            super(annotation.value(), annotation.required(), annotation.defaultValue());
        }
    }
}

