/*
 * Decompiled with CFR 0.152.
 */
package com.highgo.jdbc.hostchooser;

import com.highgo.jdbc.core.Utils;

public class PgHostSpec {
    private final String id;
    private int weight;
    private int connectNum;

    public PgHostSpec(String id, int weight) {
        this.id = id;
        this.weight = weight;
    }

    public PgHostSpec(String host, String port, int weight) {
        this.id = Utils.jointID(host, port);
        this.weight = weight;
    }

    public String getId() {
        return this.id;
    }

    public int getConnectNum() {
        return this.connectNum;
    }

    public void setConnectNum(int connectNum) {
        this.connectNum = connectNum;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public synchronized void increaseConnect() {
        ++this.connectNum;
    }

    public synchronized void reduceConnect() {
        --this.connectNum;
    }

    public float getLoad() {
        if (this.weight == 0) {
            return Float.MAX_VALUE;
        }
        return (float)this.connectNum / (float)this.weight;
    }

    public String toString() {
        return "id : " + this.id + ", weight :" + this.weight + ", connectNum : " + this.connectNum;
    }
}

