/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.id;

import java.net.InetAddress;
import org.dromara.mybatis.jpa.id.IdentifierGenerator;
import org.dromara.mybatis.jpa.util.BytesHelper;

public class UUIDHexGenerator
implements IdentifierGenerator {
    private String sep = "-";
    private static final int IP;
    private static short counter;
    private static final int JVM;

    static {
        int ipadd;
        try {
            ipadd = BytesHelper.toInt(InetAddress.getLocalHost().getAddress());
        }
        catch (Exception e) {
            ipadd = 0;
        }
        IP = ipadd;
        counter = 0;
        JVM = (int)(System.currentTimeMillis() >>> 8);
    }

    @Override
    public String generate(Object object) {
        return String.valueOf(this.format(this.getIP())) + this.sep + this.format(this.getJVM()) + this.sep + this.format(this.getHiTime()) + this.sep + this.format(this.getLoTime()) + this.sep + this.format(this.getCount());
    }

    protected String format(int intValue) {
        String formatted = Integer.toHexString(intValue);
        StringBuilder buf = new StringBuilder("00000000");
        buf.replace(8 - formatted.length(), 8, formatted);
        return buf.toString();
    }

    protected String format(short shortValue) {
        String formatted = Integer.toHexString(shortValue);
        StringBuilder buf = new StringBuilder("0000");
        buf.replace(4 - formatted.length(), 4, formatted);
        return buf.toString();
    }

    protected int getJVM() {
        return JVM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected short getCount() {
        Class<UUIDHexGenerator> clazz = UUIDHexGenerator.class;
        synchronized (UUIDHexGenerator.class) {
            if (counter < 0) {
                counter = 0;
            }
            short s = counter;
            counter = (short)(s + 1);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return s;
        }
    }

    protected int getIP() {
        return IP;
    }

    protected short getHiTime() {
        return (short)(System.currentTimeMillis() >>> 32);
    }

    protected int getLoTime() {
        return (int)System.currentTimeMillis();
    }
}

