/*
 * Decompiled with CFR 0.152.
 */
package com.highgo.jdbc.jdbc;

import com.highgo.jdbc.jdbc.HGBlobOutputStream;
import com.highgo.jdbc.util.GT;
import com.highgo.jdbc.util.PSQLException;
import com.highgo.jdbc.util.PSQLState;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;

public class HGBlob
implements Blob {
    private byte[] byteArray;
    private long length = -1L;
    private boolean isClosed = false;

    public HGBlob(byte[] byteArray) throws SQLException {
        if (byteArray == null) {
            throw new PSQLException(GT.tr("the value is null", new Object[0]), PSQLState.DATA_ERROR);
        }
        this.length = byteArray.length;
        this.byteArray = byteArray;
    }

    @Override
    public synchronized void free() throws SQLException {
        this.byteArray = null;
        this.length = -1L;
        this.isClosed = true;
    }

    @Override
    public synchronized void truncate(long len) throws SQLException {
        this.checkFreed();
        if (len < 0L) {
            throw new PSQLException(GT.tr("Cannot truncate LOB to a negative length.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (len > Integer.MAX_VALUE) {
            throw new PSQLException(GT.tr("PostgreSQL LOBs can only index to: {0}", Integer.MAX_VALUE), PSQLState.INVALID_PARAMETER_VALUE);
        }
        byte[] newByteArray = new byte[(int)len];
        System.arraycopy(this.byteArray, 0, newByteArray, 0, (int)len);
        this.byteArray = newByteArray;
    }

    @Override
    public synchronized long length() throws SQLException {
        this.checkFreed();
        return this.length;
    }

    @Override
    public synchronized int setBytes(long pos, byte[] bytes) throws SQLException {
        return this.setBytes(pos, bytes, 0, bytes.length);
    }

    @Override
    public synchronized int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        this.checkFreed();
        if (bytes == null) {
            throw new PSQLException(GT.tr("The value is null.", new Object[0]), PSQLState.DATA_ERROR);
        }
        if (offset < 0 || offset > bytes.length) {
            throw new PSQLException(GT.tr("Invlid offset parameter.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (len < 0 || len > bytes.length - offset) {
            throw new PSQLException(GT.tr("Invlid length parameter.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (pos < 1L || pos > this.length + 1L) {
            throw new PSQLException(GT.tr("Invlid position parameter.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if ((long)len + pos - 1L > this.length) {
            if (pos + (long)len > Integer.MAX_VALUE) {
                throw new PSQLException(GT.tr("The data is too large.", Integer.MAX_VALUE), PSQLState.INVALID_PARAMETER_VALUE);
            }
            byte[] tmpByteArray = new byte[(int)(pos + (long)len - 1L)];
            if (this.byteArray.length > 0) {
                System.arraycopy(this.byteArray, 0, tmpByteArray, 0, this.byteArray.length);
            }
            System.arraycopy(bytes, offset, tmpByteArray, (int)pos - 1, len);
            this.byteArray = tmpByteArray;
        } else {
            System.arraycopy(bytes, offset, this.byteArray, (int)pos - 1, len);
        }
        this.length = this.byteArray.length;
        return len;
    }

    @Override
    public synchronized byte[] getBytes(long pos, int length) throws SQLException {
        this.assertPosition(pos, length);
        if (pos >= this.length) {
            pos = this.length;
        }
        if (pos - 1L + (long)length > this.length) {
            length = (int)(this.length - pos + 1L);
        }
        byte[] res = new byte[length];
        System.arraycopy(this.byteArray, (int)pos - 1, res, 0, length);
        return res;
    }

    @Override
    public synchronized InputStream getBinaryStream() throws SQLException {
        this.checkFreed();
        if (this.byteArray == null) {
            throw new PSQLException(GT.tr("The value is null.", new Object[0]), PSQLState.DATA_ERROR);
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(this.byteArray);
        return bais;
    }

    @Override
    public synchronized InputStream getBinaryStream(long pos, long length) throws SQLException {
        this.checkFreed();
        if (pos < 0L || pos > this.length - 1L) {
            throw new PSQLException(GT.tr("Invlid position parameter.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (length > this.length || pos + length > this.length) {
            throw new PSQLException(GT.tr("Invlid length parameter.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
        }
        return new ByteArrayInputStream(this.byteArray, (int)(--pos), (int)length);
    }

    @Override
    public synchronized OutputStream setBinaryStream(long pos) throws SQLException {
        this.assertPosition(pos);
        return new HGBlobOutputStream(this, pos);
    }

    @Override
    public synchronized long position(byte[] pattern, long start) throws SQLException {
        if (pattern == null) {
            throw new PSQLException(GT.tr("The pattern cannot be null", new Object[0]), PSQLState.DATA_ERROR);
        }
        this.assertPosition(start, pattern.length);
        int i = (int)(--start);
        while ((long)i < this.length - (long)pattern.length) {
            boolean j = true;
            for (int k = 0; k < pattern.length; ++k) {
                if (this.byteArray[i + k] == pattern[k]) continue;
                j = false;
                break;
            }
            if (j) {
                return i + 1;
            }
            ++i;
        }
        return -1L;
    }

    @Override
    public synchronized long position(Blob pattern, long start) throws SQLException {
        return this.position(pattern.getBytes(1L, (int)pattern.length()), start);
    }

    protected void assertPosition(long pos) throws SQLException {
        this.assertPosition(pos, 0L);
    }

    protected void assertPosition(long pos, long len) throws SQLException {
        this.checkFreed();
        if (pos < 1L) {
            throw new PSQLException(GT.tr("LOB positioning offsets start at 1.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (pos + len - 1L > Integer.MAX_VALUE) {
            throw new PSQLException(GT.tr("PostgreSQL LOBs can only index to: {0}", Integer.MAX_VALUE), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (len < 0L) {
            throw new PSQLException(GT.tr("the length cannot less than 0", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
        }
    }

    protected void checkFreed() throws SQLException {
        if (this.isClosed) {
            throw new PSQLException(GT.tr("free() was called on this LOB previously", new Object[0]), PSQLState.OBJECT_NOT_IN_STATE);
        }
    }
}

