/*
 * Decompiled with CFR 0.152.
 */
package org.maxkey.authz.token.endpoint.adapter;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.jwt.SignedJWT;
import java.util.Arrays;
import java.util.Date;
import java.util.UUID;
import org.joda.time.DateTime;
import org.maxkey.authz.endpoint.adapter.AbstractAuthorizeAdapter;
import org.maxkey.config.oidc.OIDCProviderMetadata;
import org.maxkey.crypto.jwt.signer.service.JwtSigningAndValidationService;
import org.maxkey.domain.UserInfo;
import org.maxkey.domain.apps.Apps;
import org.maxkey.domain.apps.AppsTokenBasedDetails;
import org.maxkey.web.WebContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;

public class TokenBasedJWTAdapter
extends AbstractAuthorizeAdapter {
    static final Logger _logger = LoggerFactory.getLogger(TokenBasedJWTAdapter.class);

    public String generateInfo(UserInfo userInfo, Object app) {
        AppsTokenBasedDetails details = (AppsTokenBasedDetails)app;
        JwtSigningAndValidationService jwtSignerService = (JwtSigningAndValidationService)WebContext.getBean((String)"jwtSignerValidationService");
        OIDCProviderMetadata providerMetadata = (OIDCProviderMetadata)WebContext.getBean((String)"oidcProviderMetadata");
        DateTime currentDateTime = DateTime.now();
        Date expirationTime = currentDateTime.plusMinutes(Integer.parseInt(details.getExpires())).toDate();
        _logger.debug("expiration Time : " + expirationTime);
        JWTClaimsSet jwtClaims = new JWTClaimsSet.Builder().issuer(providerMetadata.getIssuer()).subject(userInfo.getUsername()).audience(Arrays.asList(details.getId())).jwtID(UUID.randomUUID().toString()).issueTime(currentDateTime.toDate()).expirationTime(expirationTime).claim("email", (Object)userInfo.getWorkEmail()).claim("name", (Object)userInfo.getUsername()).claim("user_id", (Object)userInfo.getId()).claim("external_id", (Object)userInfo.getId()).claim("locale", (Object)userInfo.getLocale()).claim("kid", (Object)jwtSignerService.getDefaultSignerKeyId()).build();
        _logger.debug("jwt Claims : " + jwtClaims);
        PlainJWT jwtToken = new PlainJWT(jwtClaims);
        JWSAlgorithm signingAlg = jwtSignerService.getDefaultSigningAlgorithm();
        _logger.debug(" signingAlg " + signingAlg);
        jwtToken = new SignedJWT(new JWSHeader(signingAlg), jwtClaims);
        jwtSignerService.signJwt((SignedJWT)jwtToken);
        String tokenString = jwtToken.serialize();
        _logger.debug("jwt Token : " + tokenString);
        return tokenString;
    }

    public String encrypt(String data, String algorithmKey, String algorithm) {
        return data;
    }

    public String sign(String data, Apps app) {
        return data;
    }

    public ModelAndView authorize(UserInfo userInfo, Object app, String data, ModelAndView modelAndView) {
        modelAndView.setViewName("authorize/tokenbased_jwt_sso_submint");
        AppsTokenBasedDetails details = (AppsTokenBasedDetails)app;
        modelAndView.addObject("action", (Object)details.getRedirectUri());
        _logger.debug("jwt Token data : " + data);
        modelAndView.addObject("token", (Object)data);
        return modelAndView;
    }
}

