/*
 * Decompiled with CFR 0.152.
 */
package org.maxkey.authz.exapi.endpoint;

import javax.servlet.http.HttpServletRequest;
import org.maxkey.authz.endpoint.AuthorizeBaseEndpoint;
import org.maxkey.authz.endpoint.adapter.AbstractAuthorizeAdapter;
import org.maxkey.constants.BOOLEAN;
import org.maxkey.domain.Accounts;
import org.maxkey.domain.apps.Apps;
import org.maxkey.util.Instance;
import org.maxkey.web.WebContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ExtendApiAuthorizeEndpoint
extends AuthorizeBaseEndpoint {
    static final Logger _logger = LoggerFactory.getLogger(ExtendApiAuthorizeEndpoint.class);

    @RequestMapping(value={"/authz/api/{id}"})
    public ModelAndView authorize(HttpServletRequest request, @PathVariable(value="id") String id) {
        Apps apps = this.getApp(id);
        _logger.debug("" + apps);
        if (BOOLEAN.isTrue((int)apps.getIsAdapter())) {
            Accounts appUser = this.getAccounts(apps);
            if (appUser == null) {
                return this.generateInitCredentialModelAndView(id, "/authorize/api/" + id);
            }
            ModelAndView modelAndView = new ModelAndView();
            AbstractAuthorizeAdapter adapter = (AbstractAuthorizeAdapter)Instance.newInstance((String)apps.getAdapter());
            apps.setAppUser(appUser);
            modelAndView = adapter.authorize(WebContext.getUserInfo(), (Object)apps, appUser.getRelatedUsername() + "." + appUser.getRelatedPassword(), modelAndView);
            return modelAndView;
        }
        String redirec_uri = this.getApp(id).getLoginUrl();
        return WebContext.redirect((String)redirec_uri);
    }
}

