/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.ssl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import javax.crypto.spec.RC5ParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.ssl.ASN1Structure;
import org.apache.commons.ssl.ASN1Util;
import org.apache.commons.ssl.DerivedKey;
import org.apache.commons.ssl.JavaImpl;
import org.apache.commons.ssl.OpenSSL;
import org.apache.commons.ssl.PEMItem;
import org.apache.commons.ssl.PEMUtil;
import org.apache.commons.ssl.ProbablyBadPasswordException;
import org.apache.commons.ssl.ProbablyNotPKCS8Exception;
import org.apache.commons.ssl.Util;
import org.apache.commons.ssl.asn1.ASN1EncodableVector;
import org.apache.commons.ssl.asn1.ASN1OutputStream;
import org.apache.commons.ssl.asn1.DEREncodable;
import org.apache.commons.ssl.asn1.DERInteger;
import org.apache.commons.ssl.asn1.DERNull;
import org.apache.commons.ssl.asn1.DERObjectIdentifier;
import org.apache.commons.ssl.asn1.DEROctetString;
import org.apache.commons.ssl.asn1.DERSequence;

public class PKCS8Key {
    public static final String RSA_OID = "1.2.840.113549.1.1.1";
    public static final String DSA_OID = "1.2.840.10040.4.1";
    public static final String PKCS8_UNENCRYPTED = "PRIVATE KEY";
    public static final String PKCS8_ENCRYPTED = "ENCRYPTED PRIVATE KEY";
    public static final String OPENSSL_RSA = "RSA PRIVATE KEY";
    public static final String OPENSSL_DSA = "DSA PRIVATE KEY";
    private final PrivateKey privateKey;
    private final byte[] decryptedBytes;
    private final String transformation;
    private final int keySize;
    private final boolean isDSA;
    private final boolean isRSA;

    public PKCS8Key(InputStream in, char[] password) throws GeneralSecurityException, IOException {
        this(Util.streamToBytes(in), password);
    }

    public PKCS8Key(ByteArrayInputStream in, char[] password) throws GeneralSecurityException {
        this(Util.streamToBytes(in), password);
    }

    public PKCS8Key(byte[] encoded, char[] password) throws GeneralSecurityException {
        PrivateKey pk;
        byte[] decryptedPKCS8;
        ASN1Structure pkcs8;
        DecryptResult decryptResult = new DecryptResult("UNENCRYPTED", 0, encoded);
        List pemItems = PEMUtil.decode(encoded);
        PEMItem keyItem = null;
        byte[] derBytes = null;
        if (pemItems.isEmpty()) {
            derBytes = encoded;
        } else {
            Iterator it = pemItems.iterator();
            boolean opensslRSA = false;
            boolean opensslDSA = false;
            while (it.hasNext()) {
                PEMItem item = (PEMItem)it.next();
                String type = item.pemType.trim().toUpperCase();
                boolean plainPKCS8 = type.startsWith(PKCS8_UNENCRYPTED);
                boolean encryptedPKCS8 = type.startsWith(PKCS8_ENCRYPTED);
                boolean rsa = type.startsWith(OPENSSL_RSA);
                boolean dsa = type.startsWith(OPENSSL_DSA);
                if (!plainPKCS8 && !encryptedPKCS8 && !rsa && !dsa) continue;
                opensslRSA = opensslRSA || rsa;
                boolean bl = opensslDSA = opensslDSA || dsa;
                if (derBytes != null) {
                    throw new ProbablyNotPKCS8Exception("More than one pkcs8 or OpenSSL key found in the supplied PEM Base64 stream");
                }
                derBytes = item.getDerBytes();
                keyItem = item;
                decryptResult = new DecryptResult("UNENCRYPTED", 0, derBytes);
            }
            if (derBytes == null) {
                throw new ProbablyNotPKCS8Exception("No pkcs8 or OpenSSL key found in the supplied PEM Base64 stream");
            }
            if (opensslDSA || opensslRSA) {
                boolean encrypted;
                String c = keyItem.cipher.trim();
                boolean bl = encrypted = !"UNKNOWN".equals(c) && !"".equals(c);
                if (encrypted) {
                    decryptResult = PKCS8Key.opensslDecrypt(keyItem, password);
                }
                String oid = RSA_OID;
                if (opensslDSA) {
                    oid = DSA_OID;
                }
                derBytes = PKCS8Key.formatAsPKCS8(decryptResult.bytes, oid, null);
                String tf = decryptResult.transformation;
                int ks = decryptResult.keySize;
                decryptResult = new DecryptResult(tf, ks, derBytes);
            }
        }
        try {
            pkcs8 = ASN1Util.analyze(derBytes);
        }
        catch (Exception e) {
            throw new ProbablyNotPKCS8Exception("asn1 parse failure: " + e);
        }
        String oid = RSA_OID;
        int derIntegerCount = -1;
        if (pkcs8.derIntegers != null) {
            derIntegerCount = pkcs8.derIntegers.size();
        }
        switch (derIntegerCount) {
            case 6: {
                oid = DSA_OID;
            }
            case 9: {
                derBytes = PKCS8Key.formatAsPKCS8(derBytes, oid, pkcs8);
                pkcs8.oid1 = oid;
                String tf = decryptResult.transformation;
                int ks = decryptResult.keySize;
                decryptResult = new DecryptResult(tf, ks, derBytes);
                break;
            }
        }
        oid = pkcs8.oid1;
        if (!oid.startsWith("1.2.840.113549.1")) {
            boolean isOkay = false;
            if (oid.startsWith("1.2.840.10040.4.")) {
                String s = oid.substring("1.2.840.10040.4.".length());
                boolean bl = isOkay = s.equals("1") || s.startsWith("1.") || s.equals("3") || s.startsWith("3.");
            }
            if (!isOkay) {
                throw new ProbablyNotPKCS8Exception("Valid ASN.1, but not PKCS8 or OpenSSL format.  OID=" + oid);
            }
        }
        boolean isRSA = RSA_OID.equals(oid);
        boolean isDSA = DSA_OID.equals(oid);
        boolean encrypted = !isRSA && !isDSA;
        byte[] byArray = decryptedPKCS8 = encrypted ? null : derBytes;
        if (encrypted) {
            decryptResult = PKCS8Key.decryptPKCS8(pkcs8, password);
            decryptedPKCS8 = decryptResult.bytes;
        }
        if (encrypted) {
            try {
                pkcs8 = ASN1Util.analyze(decryptedPKCS8);
            }
            catch (Exception e) {
                throw new ProbablyBadPasswordException("Decrypted stream not ASN.1.  Probably bad decryption password.");
            }
            oid = pkcs8.oid1;
            isDSA = DSA_OID.equals(oid);
        }
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(decryptedPKCS8);
        String type = "RSA";
        try {
            KeyFactory KF;
            if (isDSA) {
                type = "DSA";
                KF = KeyFactory.getInstance("DSA");
            } else {
                KF = KeyFactory.getInstance("RSA");
            }
            pk = KF.generatePrivate(spec);
        }
        catch (Exception e) {
            throw new ProbablyBadPasswordException("Cannot create " + type + " private key from decrypted stream.  Probably bad decryption password. " + e);
        }
        if (pk == null) {
            throw new GeneralSecurityException("KeyFactory.generatePrivate() returned null and didn't throw exception!");
        }
        this.privateKey = pk;
        this.isDSA = isDSA;
        this.isRSA = !isDSA;
        this.decryptedBytes = decryptedPKCS8;
        this.transformation = decryptResult.transformation;
        this.keySize = decryptResult.keySize;
    }

    public boolean isRSA() {
        return this.isRSA;
    }

    public boolean isDSA() {
        return this.isDSA;
    }

    public String getTransformation() {
        return this.transformation;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public byte[] getDecryptedBytes() {
        return this.decryptedBytes;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    private static DecryptResult opensslDecrypt(PEMItem item, char[] password) throws GeneralSecurityException {
        String cipher = item.cipher;
        String mode = item.mode;
        int keySize = item.keySizeInBits;
        byte[] salt = item.iv;
        boolean des2 = item.des2;
        DerivedKey dk = OpenSSL.deriveKey(password, salt, keySize, des2);
        return PKCS8Key.decrypt(cipher, mode, dk, des2, null, item.getDerBytes());
    }

    public static Cipher generateCipher(String cipher, String mode, DerivedKey dk, boolean des2, byte[] iv, boolean decryptMode) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        if (des2 && dk.key.length >= 24) {
            System.arraycopy(dk.key, 0, dk.key, 16, 8);
        }
        int keySize = dk.key.length * 8;
        cipher = cipher.trim();
        String cipherUpper = cipher.toUpperCase();
        mode = mode.trim().toUpperCase();
        Cipher.getInstance(cipher);
        String padding = "PKCS5Padding";
        if (mode.startsWith("CFB") || mode.startsWith("OFB")) {
            padding = "NoPadding";
        }
        String transformation = cipher + "/" + mode + "/" + padding;
        if (cipherUpper.startsWith("RC4")) {
            transformation = cipher;
        }
        SecretKeySpec secret = new SecretKeySpec(dk.key, cipher);
        IvParameterSpec ivParams = iv != null ? new IvParameterSpec(iv) : (dk.iv != null ? new IvParameterSpec(dk.iv) : null);
        Cipher c = Cipher.getInstance(transformation);
        int cipherMode = 1;
        if (decryptMode) {
            cipherMode = 2;
        }
        if (cipherUpper.startsWith("RC2")) {
            RC2ParameterSpec rcParams = mode.startsWith("ECB") || ivParams == null ? new RC2ParameterSpec(keySize) : new RC2ParameterSpec(keySize, ivParams.getIV());
            c.init(cipherMode, (Key)secret, rcParams);
        } else if (cipherUpper.startsWith("RC5")) {
            RC5ParameterSpec rcParams = mode.startsWith("ECB") || ivParams == null ? new RC5ParameterSpec(16, 12, 32) : new RC5ParameterSpec(16, 12, 32, ivParams.getIV());
            c.init(cipherMode, (Key)secret, rcParams);
        } else if (mode.startsWith("ECB") || cipherUpper.startsWith("RC4")) {
            c.init(cipherMode, secret);
        } else {
            c.init(cipherMode, (Key)secret, ivParams);
        }
        return c;
    }

    public static DecryptResult decrypt(String cipher, String mode, DerivedKey dk, boolean des2, byte[] iv, byte[] encryptedBytes) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        Cipher c = PKCS8Key.generateCipher(cipher, mode, dk, des2, iv, true);
        String transformation = c.getAlgorithm();
        int keySize = dk.key.length * 8;
        byte[] decryptedBytes = c.doFinal(encryptedBytes);
        return new DecryptResult(transformation, keySize, decryptedBytes);
    }

    private static DecryptResult decryptPKCS8(ASN1Structure pkcs8, char[] password) throws GeneralSecurityException {
        DerivedKey dk;
        boolean isVersion1 = true;
        boolean isVersion2 = false;
        boolean usePKCS12PasswordPadding = false;
        boolean use2DES = false;
        String cipher = null;
        String hash = null;
        int keySize = -1;
        String mode = "CBC";
        int ivSize = 0;
        String oid = pkcs8.oid1;
        if (oid.startsWith("1.2.840.113549.1.12.")) {
            usePKCS12PasswordPadding = true;
            if ((oid = oid.substring("1.2.840.113549.1.12.".length())).equals("1.1") || oid.startsWith("1.1.")) {
                hash = "SHA1";
                cipher = "RC4";
                keySize = 128;
            } else if (oid.equals("1.2") || oid.startsWith("1.2.")) {
                hash = "SHA1";
                cipher = "RC4";
                keySize = 40;
            } else if (oid.equals("1.3") || oid.startsWith("1.3.")) {
                hash = "SHA1";
                cipher = "DESede";
                keySize = 192;
            } else if (oid.equals("1.4") || oid.startsWith("1.4.")) {
                hash = "SHA1";
                cipher = "DESede";
                keySize = 192;
                use2DES = true;
            } else if (oid.equals("1.5") || oid.startsWith("1.5.")) {
                hash = "SHA1";
                cipher = "RC2";
                keySize = 128;
            } else if (oid.equals("1.6") || oid.startsWith("1.6.")) {
                hash = "SHA1";
                cipher = "RC2";
                keySize = 40;
            }
        } else if (oid.startsWith("1.2.840.113549.1.5.")) {
            if ((oid = oid.substring("1.2.840.113549.1.5.".length())).equals("1") || oid.startsWith("1.")) {
                hash = "MD2";
                cipher = "DES";
                keySize = 64;
            } else if (oid.equals("3") || oid.startsWith("3.")) {
                hash = "MD5";
                cipher = "DES";
                keySize = 64;
            } else if (oid.equals("4") || oid.startsWith("4.")) {
                hash = "MD2";
                cipher = "RC2";
                keySize = 64;
            } else if (oid.equals("6") || oid.startsWith("6.")) {
                hash = "MD5";
                cipher = "RC2";
                keySize = 64;
            } else if (oid.equals("10") || oid.startsWith("10.")) {
                hash = "SHA1";
                cipher = "DES";
                keySize = 64;
            } else if (oid.equals("11") || oid.startsWith("11.")) {
                hash = "SHA1";
                cipher = "RC2";
                keySize = 64;
            } else if (oid.equals("12") || oid.startsWith("12.")) {
                isVersion2 = true;
            } else if (oid.equals("13") || oid.startsWith("13.")) {
                isVersion2 = true;
            } else if (oid.equals("14") || oid.startsWith("14.")) {
                isVersion2 = true;
            }
        }
        if (isVersion2) {
            isVersion1 = false;
            hash = "HmacSHA1";
            oid = pkcs8.oid2;
            if (pkcs8.oid3 != null) {
                oid = pkcs8.oid3;
            }
            if (oid.startsWith("1.3.6.1.4.1.3029.1.2")) {
                cipher = "Blowfish";
                mode = "CBC";
                keySize = 128;
            } else if (oid.startsWith("1.3.14.3.2.")) {
                if ((oid = oid.substring("1.3.14.3.2.".length())).equals("6") || oid.startsWith("6.")) {
                    cipher = "DES";
                    mode = "ECB";
                    keySize = 64;
                } else if (oid.equals("7") || oid.startsWith("7.")) {
                    cipher = "DES";
                    mode = "CBC";
                    keySize = 64;
                } else if (oid.equals("8") || oid.startsWith("8.")) {
                    cipher = "DES";
                    mode = "OFB";
                    keySize = 64;
                } else if (oid.equals("9") || oid.startsWith("9.")) {
                    cipher = "DES";
                    mode = "CFB";
                    keySize = 64;
                } else if (oid.equals("17") || oid.startsWith("17.")) {
                    cipher = "DESede";
                    mode = "CBC";
                    keySize = 192;
                    if (PKCS8Key.allZeroes(pkcs8.iv)) {
                        mode = "ECB";
                        use2DES = true;
                        pkcs8.iv = null;
                    }
                }
            } else if (oid.startsWith("2.16.840.1.101.3.4.1.")) {
                int x;
                cipher = "AES";
                if (pkcs8.iv == null) {
                    ivSize = 128;
                }
                int finalDigit = (x = (oid = oid.substring("2.16.840.1.101.3.4.1.".length())).indexOf(46)) >= 0 ? Integer.parseInt(oid.substring(0, x)) : Integer.parseInt(oid);
                switch (finalDigit % 10) {
                    case 1: {
                        mode = "ECB";
                        break;
                    }
                    case 2: {
                        mode = "CBC";
                        break;
                    }
                    case 3: {
                        mode = "OFB";
                        break;
                    }
                    case 4: {
                        mode = "CFB";
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown AES final digit: " + finalDigit);
                    }
                }
                switch (finalDigit / 10) {
                    case 0: {
                        keySize = 128;
                        break;
                    }
                    case 2: {
                        keySize = 192;
                        break;
                    }
                    case 4: {
                        keySize = 256;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown AES final digit: " + finalDigit);
                    }
                }
            } else if (oid.startsWith("1.2.840.113549.3.")) {
                if ((oid = oid.substring("1.2.840.113549.3.".length())).equals("2") || oid.startsWith("2.")) {
                    cipher = "RC2";
                    keySize = pkcs8.keySize * 8;
                } else if (oid.equals("4") || oid.startsWith("4.")) {
                    cipher = "RC4";
                    keySize = pkcs8.keySize * 8;
                } else if (oid.equals("7") || oid.startsWith("7.")) {
                    cipher = "DESede";
                    keySize = 192;
                } else if (oid.equals("9") || oid.startsWith("9.")) {
                    keySize = pkcs8.keySize * 8;
                    cipher = "RC5";
                }
            }
        }
        if (cipher == null || hash == null) {
            throw new ProbablyNotPKCS8Exception("Unsupported PKCS8 format. oid1=[" + pkcs8.oid1 + "], oid2=[" + pkcs8.oid2 + "]");
        }
        if (pkcs8.iv == null) {
            ivSize = 64;
        }
        byte[] salt = pkcs8.salt;
        int ic = pkcs8.iterationCount;
        byte[] pwd = new byte[password.length];
        for (int i = 0; i < pwd.length; ++i) {
            pwd[i] = (byte)password[i];
        }
        if (usePKCS12PasswordPadding) {
            MessageDigest md = MessageDigest.getInstance(hash);
            dk = PKCS8Key.deriveKeyPKCS12(password, salt, ic, keySize, ivSize, md);
        } else if (isVersion1) {
            MessageDigest md = MessageDigest.getInstance(hash);
            dk = PKCS8Key.deriveKeyV1(pwd, salt, ic, keySize, ivSize, md);
        } else {
            Mac mac = Mac.getInstance(hash);
            dk = PKCS8Key.deriveKeyV2(pwd, salt, ic, keySize, ivSize, mac);
        }
        return PKCS8Key.decrypt(cipher, mode, dk, use2DES, pkcs8.iv, pkcs8.bigPayload);
    }

    public static DerivedKey deriveKeyV1(byte[] password, byte[] salt, int iterations, int keySizeInBits, int ivSizeInBits, MessageDigest md) {
        int keySize = keySizeInBits / 8;
        int ivSize = ivSizeInBits / 8;
        md.reset();
        md.update(password);
        byte[] result = md.digest(salt);
        for (int i = 1; i < iterations; ++i) {
            result = md.digest(result);
        }
        byte[] key = new byte[keySize];
        byte[] iv = new byte[ivSize];
        System.arraycopy(result, 0, key, 0, key.length);
        System.arraycopy(result, key.length, iv, 0, iv.length);
        return new DerivedKey(key, iv);
    }

    public static DerivedKey deriveKeyPKCS12(char[] password, byte[] salt, int iterations, int keySizeInBits, int ivSizeInBits, MessageDigest md) {
        byte[] pwd;
        if (password.length > 0) {
            pwd = new byte[(password.length + 1) * 2];
            for (int i = 0; i < password.length; ++i) {
                pwd[i * 2] = (byte)(password[i] >>> 8);
                pwd[i * 2 + 1] = (byte)password[i];
            }
        } else {
            pwd = new byte[]{};
        }
        int keySize = keySizeInBits / 8;
        int ivSize = ivSizeInBits / 8;
        byte[] key = PKCS8Key.pkcs12(1, keySize, salt, pwd, iterations, md);
        byte[] iv = PKCS8Key.pkcs12(2, ivSize, salt, pwd, iterations, md);
        return new DerivedKey(key, iv);
    }

    private static byte[] pkcs12(int idByte, int n, byte[] salt, byte[] password, int iterationCount, MessageDigest md) {
        byte[] P;
        byte[] S;
        int u = md.getDigestLength();
        int v = 64;
        md.reset();
        byte[] D = new byte[v];
        byte[] dKey = new byte[n];
        for (int i = 0; i != D.length; ++i) {
            D[i] = (byte)idByte;
        }
        if (salt != null && salt.length != 0) {
            S = new byte[v * ((salt.length + v - 1) / v)];
            for (int i = 0; i != S.length; ++i) {
                S[i] = salt[i % salt.length];
            }
        } else {
            S = new byte[]{};
        }
        if (password != null && password.length != 0) {
            P = new byte[v * ((password.length + v - 1) / v)];
            for (int i = 0; i != P.length; ++i) {
                P[i] = password[i % password.length];
            }
        } else {
            P = new byte[]{};
        }
        byte[] I = new byte[S.length + P.length];
        System.arraycopy(S, 0, I, 0, S.length);
        System.arraycopy(P, 0, I, S.length, P.length);
        byte[] B = new byte[v];
        int c = (n + u - 1) / u;
        for (int i = 1; i <= c; ++i) {
            int j;
            md.update(D);
            byte[] result = md.digest(I);
            for (j = 1; j != iterationCount; ++j) {
                result = md.digest(result);
            }
            for (j = 0; j != B.length; ++j) {
                B[j] = result[j % result.length];
            }
            for (j = 0; j < I.length / v; ++j) {
                int aOff = j * v;
                int bLast = B.length - 1;
                int x = (B[bLast] & 0xFF) + (I[aOff + bLast] & 0xFF) + 1;
                I[aOff + bLast] = (byte)x;
                x >>>= 8;
                for (int k = B.length - 2; k >= 0; --k) {
                    I[aOff + k] = (byte)(x += (B[k] & 0xFF) + (I[aOff + k] & 0xFF));
                    x >>>= 8;
                }
            }
            if (i == c) {
                System.arraycopy(result, 0, dKey, (i - 1) * u, dKey.length - (i - 1) * u);
                continue;
            }
            System.arraycopy(result, 0, dKey, (i - 1) * u, result.length);
        }
        return dKey;
    }

    public static DerivedKey deriveKeyV2(byte[] password, byte[] salt, int iterations, int keySizeInBits, int ivSizeInBits, Mac mac) throws InvalidKeyException {
        int keySize = keySizeInBits / 8;
        int ivSize = ivSizeInBits / 8;
        SecretKeySpec sk = new SecretKeySpec(password, "N/A");
        mac.init(sk);
        int macLength = mac.getMacLength();
        int derivedKeyLength = keySize + ivSize;
        int blocks = (derivedKeyLength + macLength - 1) / macLength;
        byte[] blockIndex = new byte[4];
        byte[] finalResult = new byte[blocks * macLength];
        for (int i = 1; i <= blocks; ++i) {
            int offset = (i - 1) * macLength;
            blockIndex[0] = (byte)(i >>> 24);
            blockIndex[1] = (byte)(i >>> 16);
            blockIndex[2] = (byte)(i >>> 8);
            blockIndex[3] = (byte)i;
            mac.reset();
            mac.update(salt);
            byte[] result = mac.doFinal(blockIndex);
            System.arraycopy(result, 0, finalResult, offset, result.length);
            for (int j = 1; j < iterations; ++j) {
                mac.reset();
                result = mac.doFinal(result);
                for (int k = 0; k < result.length; ++k) {
                    int n = offset + k;
                    finalResult[n] = (byte)(finalResult[n] ^ result[k]);
                }
            }
        }
        byte[] key = new byte[keySize];
        byte[] iv = new byte[ivSize];
        System.arraycopy(finalResult, 0, key, 0, key.length);
        System.arraycopy(finalResult, key.length, iv, 0, iv.length);
        return new DerivedKey(key, iv);
    }

    public static byte[] formatAsPKCS8(byte[] privateKey, String oid, ASN1Structure pkcs8) {
        DERInteger derZero = new DERInteger(BigInteger.ZERO);
        ASN1EncodableVector outterVec = new ASN1EncodableVector();
        ASN1EncodableVector innerVec = new ASN1EncodableVector();
        try {
            DEROctetString octetsToAppend;
            DERObjectIdentifier derOID = new DERObjectIdentifier(oid);
            innerVec.add(derOID);
            if (DSA_OID.equals(oid)) {
                if (pkcs8 == null) {
                    try {
                        pkcs8 = ASN1Util.analyze(privateKey);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("asn1 parse failure " + e);
                    }
                }
                if (pkcs8.derIntegers == null || pkcs8.derIntegers.size() < 6) {
                    throw new RuntimeException("invalid DSA key - can't find P, Q, G, X");
                }
                DERInteger[] ints = new DERInteger[pkcs8.derIntegers.size()];
                pkcs8.derIntegers.toArray(ints);
                DERInteger p = ints[1];
                DERInteger q = ints[2];
                DERInteger g = ints[3];
                DERInteger x = ints[5];
                byte[] encodedX = PKCS8Key.encode(x);
                octetsToAppend = new DEROctetString(encodedX);
                ASN1EncodableVector pqgVec = new ASN1EncodableVector();
                pqgVec.add(p);
                pqgVec.add(q);
                pqgVec.add(g);
                DERSequence pqg = new DERSequence(pqgVec);
                innerVec.add(pqg);
            } else {
                innerVec.add(DERNull.INSTANCE);
                octetsToAppend = new DEROctetString(privateKey);
            }
            DERSequence inner = new DERSequence(innerVec);
            outterVec.add(derZero);
            outterVec.add(inner);
            outterVec.add(octetsToAppend);
            DERSequence outter = new DERSequence(outterVec);
            return PKCS8Key.encode(outter);
        }
        catch (IOException ioe) {
            throw JavaImpl.newRuntimeException(ioe);
        }
    }

    private static boolean allZeroes(byte[] b) {
        for (int i = 0; i < b.length; ++i) {
            if (b[i] == 0) continue;
            return false;
        }
        return true;
    }

    public static byte[] encode(DEREncodable der) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        ASN1OutputStream out = new ASN1OutputStream(baos);
        out.writeObject(der);
        out.close();
        return baos.toByteArray();
    }

    public static void main(String[] args) throws Exception {
        String password = "changeit";
        if (args.length == 0) {
            System.out.println("Usage1:  [password] [file:private-key]      Prints decrypted PKCS8 key (base64).");
            System.out.println("Usage2:  [password] [file1] [file2] etc...  Checks that all private keys are equal.");
            System.out.println("Usage2 assumes that all files can be decrypted with the same password.");
        } else if (args.length == 1 || args.length == 2) {
            FileInputStream in = new FileInputStream(args[args.length - 1]);
            if (args.length == 2) {
                password = args[0];
            }
            byte[] bytes = Util.streamToBytes(in);
            PKCS8Key key = new PKCS8Key(bytes, password.toCharArray());
            PEMItem item = new PEMItem(key.getDecryptedBytes(), PKCS8_UNENCRYPTED);
            byte[] pem = PEMUtil.encode(Collections.singleton(item));
            System.out.write(pem);
        } else {
            byte[] original = null;
            File f = new File(args[0]);
            int i = 0;
            if (!f.exists()) {
                password = args[0];
                ++i;
            }
            while (i < args.length) {
                FileInputStream in = new FileInputStream(args[i]);
                byte[] bytes = Util.streamToBytes(in);
                PKCS8Key key = null;
                try {
                    key = new PKCS8Key(bytes, password.toCharArray());
                }
                catch (Exception e) {
                    System.out.println(" FAILED! " + args[i] + " " + e);
                }
                if (key != null) {
                    String type;
                    byte[] decrypted = key.getDecryptedBytes();
                    int keySize = key.getKeySize();
                    String keySizeStr = "" + keySize;
                    if (keySize < 10) {
                        keySizeStr = "  " + keySizeStr;
                    } else if (keySize < 100) {
                        keySizeStr = " " + keySizeStr;
                    }
                    StringBuffer buf = new StringBuffer(key.getTransformation());
                    int maxLen = "Blowfish/CBC/PKCS5Padding".length();
                    for (int j = buf.length(); j < maxLen; ++j) {
                        buf.append(' ');
                    }
                    String transform = buf.toString();
                    String string = type = key.isDSA() ? "DSA" : "RSA";
                    if (original == null) {
                        original = decrypted;
                        System.out.println("   SUCCESS    \t" + type + "\t" + transform + "\t" + keySizeStr + "\t" + args[i]);
                    } else {
                        boolean identical = Arrays.equals(original, decrypted);
                        if (!identical) {
                            System.out.println("***FAILURE*** \t" + type + "\t" + transform + "\t" + keySizeStr + "\t" + args[i]);
                        } else {
                            System.out.println("   SUCCESS    \t" + type + "\t" + transform + "\t" + keySizeStr + "\t" + args[i]);
                        }
                    }
                }
                ++i;
            }
        }
    }

    static {
        JavaImpl.load();
    }

    public static class DecryptResult {
        public final String transformation;
        public final int keySize;
        public final byte[] bytes;

        protected DecryptResult(String transformation, int keySize, byte[] decryptedBytes) {
            this.transformation = transformation;
            this.keySize = keySize;
            this.bytes = decryptedBytes;
        }
    }
}

