/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.metadata;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.dromara.mybatis.jpa.crypto.EncryptFactory;
import org.dromara.mybatis.jpa.id.IdentifierGeneratorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapperMetadata {
    private static final Logger logger = LoggerFactory.getLogger(MapperMetadata.class);
    public static final String LOG_FORMAT = "%-30s";
    public static final String LOG_FORMAT_COUNT = "%-3s";
    public static final String ENTITY_CLASS = "entityClass";
    public static final String ENTITY = "entity";
    public static final String PAGE = "page";
    public static final String CONDITION = "condition";
    public static final String QUERY_FILTER = "filter";
    public static final String QUERY_ARGS = "args";
    public static final String QUERY_ARGTYPES = "argTypes";
    public static final String PARAMETER_PARTITION_KEY = "partitionKey";
    public static final String PARAMETER_ID_LIST = "idList";
    public static final String PARAMETER_ID = "id";
    public static int TABLE_COLUMN_CASE = 1;
    public static boolean TABLE_COLUMN_ESCAPE = false;
    public static String TABLE_COLUMN_ESCAPE_CHAR = "`";
    public static String PARTITION_COLUMN = "inst_id";
    static ConcurrentMap<String, String> sqlsMap = new ConcurrentHashMap<String, String>();
    static IdentifierGeneratorFactory identifierGeneratorFactory = new IdentifierGeneratorFactory();
    static EncryptFactory encryptFactory;

    public static String tableColumnCaseConverter(String name) {
        if (TABLE_COLUMN_CASE == 1) {
            name = name.toLowerCase();
        } else if (TABLE_COLUMN_CASE == 2) {
            name = name.toUpperCase();
        }
        return name;
    }

    public static String tableColumnEscape(String name) {
        return TABLE_COLUMN_ESCAPE ? TABLE_COLUMN_ESCAPE_CHAR + name + TABLE_COLUMN_ESCAPE_CHAR : name;
    }

    public static ConcurrentMap<String, String> getSqlsMap() {
        return sqlsMap;
    }

    public static void setSqlsMap(ConcurrentMap<String, String> sqlsMap) {
        MapperMetadata.sqlsMap = sqlsMap;
    }

    public static IdentifierGeneratorFactory getIdentifierGeneratorFactory() {
        return identifierGeneratorFactory;
    }

    public static void setIdentifierGeneratorFactory(IdentifierGeneratorFactory identifierGeneratorFactory) {
        MapperMetadata.identifierGeneratorFactory = identifierGeneratorFactory;
        logger.debug("Identifier Generator Factory {}", (Object)identifierGeneratorFactory);
    }

    public static EncryptFactory getEncryptFactory() {
        return encryptFactory;
    }

    public static void setEncryptFactory(EncryptFactory encryptFactory) {
        MapperMetadata.encryptFactory = encryptFactory;
    }

    public static class CASE_TYPE {
        public static final int NORMAL = 0;
        public static final int LOWERCASE = 1;
        public static final int UPPERCASE = 2;
    }

    public static class SQL_TYPE {
        public static final String GET_SQL = "_GET_SQL";
        public static final String FINDALL_SQL = "_FINDALL_SQL";
    }
}

