/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.interceptor.builder;

import java.util.Map;
import java.util.StringTokenizer;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.executor.statement.PreparedStatementHandler;
import org.apache.ibatis.executor.statement.SimpleStatementHandler;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.dromara.mybatis.jpa.dialect.Dialect;
import org.dromara.mybatis.jpa.entity.JpaPage;
import org.dromara.mybatis.jpa.entity.JpaPageSqlCache;
import org.dromara.mybatis.jpa.interceptor.builder.SelectPageSql;
import org.dromara.mybatis.jpa.provider.FetchCountProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectPageSqlBuilder {
    private static final Logger logger = LoggerFactory.getLogger(SelectPageSqlBuilder.class);

    public static SelectPageSql parse(BoundSql boundSql, Object parameterObject) {
        SelectPageSql pageSql = new SelectPageSql();
        if (boundSql.getSql().toLowerCase().trim().startsWith("select")) {
            pageSql.setSelectTrack(true);
            pageSql.setPage(SelectPageSqlBuilder.getJpaPageParameter(parameterObject));
            if (pageSql.getPage() != null && pageSql.getPage().isPageable()) {
                pageSql.setPageable(true);
            }
        }
        return pageSql;
    }

    public static String translate(StatementHandler statement, Dialect dialect, BoundSql boundSql, SelectPageSql pageSql) {
        String selectSql = boundSql.getSql();
        String boundSqlRemoveBreakingWhitespace = SelectPageSqlBuilder.removeBreakingWhitespace(selectSql);
        logger.trace("prepare  boundSql  ==> {}", (Object)boundSqlRemoveBreakingWhitespace);
        if (statement instanceof SimpleStatementHandler) {
            selectSql = dialect.getLimitString(selectSql, pageSql.getPage());
        } else if (statement instanceof PreparedStatementHandler) {
            FetchCountProvider.PAGE_BOUNDSQL_CACHE.put((Object)pageSql.getPage().getPageSelectId(), (Object)new JpaPageSqlCache(selectSql, boundSql));
            selectSql = dialect.getLimitString(selectSql, pageSql.getPage());
        }
        logger.trace("prepare dialect boundSql : {}", (Object)boundSqlRemoveBreakingWhitespace);
        return selectSql;
    }

    protected static JpaPage getJpaPageParameter(Object parameterObject) {
        JpaPage page = null;
        if (parameterObject instanceof JpaPage) {
            JpaPage jpaPage;
            page = jpaPage = (JpaPage)parameterObject;
        } else if (parameterObject instanceof MapperMethod.ParamMap) {
            MapperMethod.ParamMap paramMap = (MapperMethod.ParamMap)parameterObject;
            if (paramMap.containsKey((Object)"page")) {
                page = (JpaPage)paramMap.get((Object)"page");
            } else {
                try {
                    for (Map.Entry entry : paramMap.entrySet()) {
                        JpaPage jpaPage;
                        Object v = entry.getValue();
                        if (!(v instanceof JpaPage)) continue;
                        page = jpaPage = (JpaPage)v;
                        break;
                    }
                }
                catch (Exception e) {
                    logger.error("Exception", (Throwable)e);
                }
            }
        }
        return page;
    }

    protected static String removeBreakingWhitespace(String original) {
        StringTokenizer whitespaceStripper = new StringTokenizer(original);
        StringBuilder builder = new StringBuilder();
        while (whitespaceStripper.hasMoreTokens()) {
            builder.append(whitespaceStripper.nextToken());
            builder.append(" ");
        }
        return builder.toString();
    }
}

