/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.handler;

import org.apache.commons.text.StringEscapeUtils;

public class SafeValueHandler {
    public static String valueOf(Object value) {
        String valueType = value.getClass().getSimpleName().toLowerCase();
        if (valueType.equals("string") || valueType.equals("char") || valueType.startsWith("char")) {
            return SafeValueHandler.safeValue(value);
        }
        if (valueType.equals("int") || valueType.equals("long") || valueType.equals("integer") || valueType.equals("float") || valueType.equals("double")) {
            return String.valueOf(value);
        }
        return SafeValueHandler.safeValue(value);
    }

    public static String valueOfType(Object value) {
        String valueType = value.getClass().getSimpleName().toLowerCase();
        if (valueType.equals("string") || valueType.equals("char") || valueType.startsWith("char")) {
            return "'" + SafeValueHandler.safeValue(value) + "'";
        }
        if (valueType.equals("int") || valueType.equals("long") || valueType.equals("integer") || valueType.equals("float") || valueType.equals("double")) {
            return String.valueOf(value);
        }
        return "'" + SafeValueHandler.safeValue(value) + "'";
    }

    public static String safeValue(Object value) {
        String replace = "";
        if (value != null) {
            replace = StringEscapeUtils.escapeHtml4((String)String.valueOf(value));
            if (replace.indexOf("'") > -1) {
                replace = replace.replace("'", "0x27");
            }
            if (replace.indexOf("--") > -1) {
                replace = replace.replace("--", "0x2D0x2D");
            }
            if (replace.indexOf("#") > -1) {
                replace = replace.replace("#", "0x23");
            }
        }
        return replace;
    }

    public static String safeColumn(String column) {
        return column.replace("'", "").replace(" ", "").replace(";", "").replace("--", "0x2D0x2D");
    }

    public final class SingleQuote {
        public static final String SYMBOL = "'";
        public static final String REPLACE = "0x27";
    }

    public final class DECREMENT {
        public static final String SYMBOL = "--";
        public static final String REPLACE = "0x2D0x2D";
    }

    public final class NUMBER_SIGN {
        public static final String SYMBOL = "#";
        public static final String REPLACE = "0x23";
    }
}

