/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.ws.transport.http;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.opensaml.ws.security.ServletRequestX509CredentialAdapter;
import org.opensaml.ws.transport.http.HTTPInTransport;
import org.opensaml.ws.transport.http.HTTPTransport;
import org.opensaml.xml.security.credential.Credential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServletRequestAdapter
implements HTTPInTransport {
    private HttpServletRequest httpServletRequest;
    private final Logger log = LoggerFactory.getLogger(HttpServletRequestAdapter.class);
    private boolean peerAuthenticated;
    private Credential peerCredential;

    public HttpServletRequestAdapter(HttpServletRequest request) {
        this.httpServletRequest = request;
    }

    @Override
    public Object getAttribute(String name) {
        return this.httpServletRequest.getAttribute(name);
    }

    @Override
    public String getCharacterEncoding() {
        return this.httpServletRequest.getCharacterEncoding();
    }

    @Override
    public String getHeaderValue(String name) {
        if (name.equalsIgnoreCase("Content-Type")) {
            return this.httpServletRequest.getContentType();
        }
        if (name.equalsIgnoreCase("Content-Length")) {
            return Integer.toString(this.httpServletRequest.getContentLength());
        }
        return this.httpServletRequest.getHeader(name);
    }

    @Override
    public String getHTTPMethod() {
        return this.httpServletRequest.getMethod();
    }

    @Override
    public InputStream getIncomingStream() {
        try {
            return this.httpServletRequest.getInputStream();
        }
        catch (IOException e) {
            this.log.error("Unable to recover input stream from adapted HttpServletRequest", (Throwable)e);
            return null;
        }
    }

    @Override
    public Credential getLocalCredential() {
        return null;
    }

    @Override
    public String getParameterValue(String name) {
        return this.httpServletRequest.getParameter(name);
    }

    @Override
    public List<String> getParameterValues(String name) {
        ArrayList<String> valuesList = new ArrayList<String>();
        String[] values = this.httpServletRequest.getParameterValues(name);
        if (values != null) {
            for (String value : values) {
                valuesList.add(value);
            }
        }
        return valuesList;
    }

    @Override
    public String getPeerAddress() {
        return this.httpServletRequest.getRemoteAddr();
    }

    @Override
    public Credential getPeerCredential() {
        if (this.peerCredential == null) {
            try {
                this.peerCredential = new ServletRequestX509CredentialAdapter((ServletRequest)this.httpServletRequest);
            }
            catch (IllegalArgumentException e) {
                this.log.info("Wrapped HTTP servlet request did not contain a client certificate");
            }
        }
        return this.peerCredential;
    }

    @Override
    public String getPeerDomainName() {
        return this.httpServletRequest.getRemoteHost();
    }

    @Override
    public int getStatusCode() {
        return -1;
    }

    @Override
    public HTTPTransport.HTTP_VERSION getVersion() {
        return null;
    }

    public HttpServletRequest getWrappedRequest() {
        return this.httpServletRequest;
    }

    @Override
    public boolean isAuthenticated() {
        return this.peerAuthenticated;
    }

    @Override
    public boolean isConfidential() {
        return this.httpServletRequest.isSecure();
    }

    @Override
    public void setAuthenticated(boolean isAuthenticated) {
        this.peerAuthenticated = isAuthenticated;
    }

    @Override
    public void setConfidential(boolean isConfidential) {
    }

    @Override
    public boolean isIntegrityProtected() {
        return this.httpServletRequest.isSecure();
    }

    @Override
    public void setIntegrityProtected(boolean isIntegrityProtected) {
    }
}

