/*
 * Decompiled with CFR 0.152.
 */
package com.highgo.jdbc.hostchooser;

import com.highgo.jdbc.PGProperty;
import com.highgo.jdbc.hostchooser.CandidateHost;
import com.highgo.jdbc.hostchooser.GlobalHostStatusTracker;
import com.highgo.jdbc.hostchooser.HostBalancer;
import com.highgo.jdbc.hostchooser.HostChooser;
import com.highgo.jdbc.hostchooser.HostRequirement;
import com.highgo.jdbc.hostchooser.PgHostSpec;
import com.highgo.jdbc.hostchooser.PgHostSpecFactory;
import com.highgo.jdbc.util.HostSpec;
import com.highgo.jdbc.util.PSQLException;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

class MultiHostChooser
implements HostChooser {
    private HostSpec[] hostSpecs;
    private final HostRequirement targetServerType;
    private HostBalancer hostBalancer;
    private int hostRecheckTime;
    private boolean loadBalance;

    MultiHostChooser(HostSpec[] hostSpecs, HostRequirement targetServerType, HostBalancer hostBalancer, Properties info) {
        this.hostSpecs = hostSpecs;
        this.targetServerType = targetServerType;
        this.hostBalancer = hostBalancer;
        try {
            this.hostRecheckTime = PGProperty.HOST_RECHECK_SECONDS.getInt(info) * 1000;
            this.loadBalance = PGProperty.LOAD_BALANCE_HOSTS.getBoolean(info);
        }
        catch (PSQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Iterator<CandidateHost> iterator() {
        Iterator<CandidateHost> res = this.candidateIterator();
        if (!res.hasNext()) {
            List<HostSpec> allHosts = Arrays.asList(this.hostSpecs);
            if (this.loadBalance) {
                allHosts = this.loadBalance(allHosts);
            }
            res = this.withReqStatus(this.targetServerType, allHosts).iterator();
        }
        return res;
    }

    private Iterator<CandidateHost> candidateIterator() {
        if (this.targetServerType != HostRequirement.preferSecondary) {
            return this.getCandidateHosts(this.targetServerType).iterator();
        }
        List<CandidateHost> secondaries = this.getCandidateHosts(HostRequirement.secondary);
        List<CandidateHost> any = this.getCandidateHosts(HostRequirement.any);
        if (secondaries.isEmpty()) {
            return any.iterator();
        }
        if (any.isEmpty()) {
            return secondaries.iterator();
        }
        if (secondaries.get(secondaries.size() - 1).equals(any.get(0))) {
            secondaries = this.rtrim(1, secondaries);
        }
        return this.append(secondaries, any).iterator();
    }

    private List<CandidateHost> getCandidateHosts(HostRequirement hostRequirement) {
        List<HostSpec> candidates = GlobalHostStatusTracker.getCandidateHosts(this.hostSpecs, hostRequirement, this.hostRecheckTime);
        if (this.loadBalance) {
            candidates = this.loadBalance(candidates);
        }
        return this.withReqStatus(hostRequirement, candidates);
    }

    private List<CandidateHost> withReqStatus(final HostRequirement requirement, final List<HostSpec> hosts) {
        return new AbstractList<CandidateHost>(){

            @Override
            public CandidateHost get(int index) {
                return new CandidateHost((HostSpec)hosts.get(index), requirement);
            }

            @Override
            public int size() {
                return hosts.size();
            }
        };
    }

    private <T> List<T> append(final List<T> a, final List<T> b) {
        return new AbstractList<T>(){

            @Override
            public T get(int index) {
                return index < a.size() ? a.get(index) : b.get(index - a.size());
            }

            @Override
            public int size() {
                return a.size() + b.size();
            }
        };
    }

    private <T> List<T> rtrim(final int size, final List<T> a) {
        return new AbstractList<T>(){

            @Override
            public T get(int index) {
                return a.get(index);
            }

            @Override
            public int size() {
                return Math.max(0, a.size() - size);
            }
        };
    }

    private List<HostSpec> loadBalance(List<HostSpec> candidates) {
        if (this.hostBalancer == HostBalancer.shuffle) {
            Collections.shuffle(candidates);
        } else if (this.hostBalancer == HostBalancer.random) {
            int count = 0;
            for (HostSpec hostSpec : this.hostSpecs) {
                PgHostSpec pgHostSpec = PgHostSpecFactory.getInstance().getPgHostSpec(hostSpec);
                count += pgHostSpec.getWeight();
            }
            if (count == 0) {
                Collections.shuffle(candidates);
            } else {
                double random = Math.random() * (double)count;
                int tempCount = 0;
                for (int i = 0; i < this.hostSpecs.length; ++i) {
                    int preTempCount = tempCount;
                    tempCount += PgHostSpecFactory.getInstance().getPgHostSpec(this.hostSpecs[i]).getWeight();
                    if (!(random >= (double)preTempCount) || !(random < (double)tempCount)) continue;
                    HostSpec temp = this.hostSpecs[0];
                    this.hostSpecs[0] = this.hostSpecs[i];
                    this.hostSpecs[i] = temp;
                    break;
                }
                candidates = Arrays.asList(this.hostSpecs);
            }
        } else if (this.hostBalancer == HostBalancer.load) {
            HostSpec temp = null;
            int count = 0;
            for (HostSpec hostSpec : this.hostSpecs) {
                PgHostSpec pgHostSpec = PgHostSpecFactory.getInstance().getPgHostSpec(hostSpec);
                count += pgHostSpec.getWeight();
            }
            if (count == 0) {
                Collections.shuffle(candidates);
            } else {
                for (int i = 0; i < this.hostSpecs.length; ++i) {
                    boolean hasChange = false;
                    for (int j = 0; j < this.hostSpecs.length - 1 - i; ++j) {
                        if (!(PgHostSpecFactory.getInstance().getPgHostSpec(this.hostSpecs[j]).getLoad() > PgHostSpecFactory.getInstance().getPgHostSpec(this.hostSpecs[j + 1]).getLoad())) continue;
                        temp = this.hostSpecs[j];
                        this.hostSpecs[j] = this.hostSpecs[j + 1];
                        this.hostSpecs[j + 1] = temp;
                        hasChange = true;
                    }
                    if (!hasChange) break;
                }
                candidates = Arrays.asList(this.hostSpecs);
            }
        }
        return candidates;
    }
}

